% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{get_pycox_activation}
\alias{get_pycox_activation}
\title{Get Pytorch Activation Function}
\usage{
get_pycox_activation(
  activation = "relu",
  construct = TRUE,
  alpha = 1,
  dim = NULL,
  lambd = 0.5,
  min_val = -1,
  max_val = 1,
  negative_slope = 0.01,
  num_parameters = 1L,
  init = 0.25,
  lower = 1/8,
  upper = 1/3,
  beta = 1,
  threshold = 20,
  value = 20
)
}
\arguments{
\item{activation}{\code{(character(1))}\cr Activation function method, see details for list of
implemented methods.}

\item{construct}{\code{(logical(1))}\cr If \code{TRUE} (default) returns constructed object, otherwise
a class.}

\item{alpha}{\code{(numeric(1))}\cr Passed to \code{celu} and \code{elu}.}

\item{dim}{\code{(integer(1))}\cr Passed to \code{glu}, \code{logsoftmax}, \code{softmax}, and \code{softmin}.}

\item{lambd}{\code{(numeric(1))}\cr Passed to \code{hardshrink} and \code{softshrink}.}

\item{min_val, max_val}{\code{(numeric(1))}\cr Passed to \code{hardtanh}.}

\item{negative_slope}{\code{(numeric(1))}\cr Passed to \code{leakyrelu}.}

\item{num_parameters}{\code{(integer(1))}\cr Passed to \code{prelu}.}

\item{init}{\code{(numeric(1))}\cr Passed to \code{prelu}.}

\item{lower, upper}{\code{(numeric(1))}\cr Passed to \code{rrelu}.}

\item{beta}{\code{(numeric(1))}\cr Passed to \code{softplus}.}

\item{threshold}{\code{(numeric(1))}\cr Passed to \code{softplus} and \code{threshold}.}

\item{value}{\code{(numeric(1))}\cr Passed to \code{threshold}.}
}
\description{
Helper function to return a class or constructed object for pytorch activation
function from \code{torch.nn.modules.activation}.
}
\details{
Implemented methods (with help pages) are
\itemize{
\item \code{"celu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$CELU)}
\item \code{"elu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$ELU)}
\item \code{"gelu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$GELU)}
\item \code{"glu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$GLU)}
\item \code{"hardshrink"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Hardshrink)}
\item \code{"hardsigmoid"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Hardsigmoid)}
\item \code{"hardswish"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Hardswish)}
\item \code{"hardtanh"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Hardtanh)}
\item \code{"relu6"} \cr \code{reticulate::py_help(torch$nn$modules$activation$ReLU6)}
\item \code{"leakyrelu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$LeakyReLU)}
\item \code{"logsigmoid"} \cr \code{reticulate::py_help(torch$nn$modules$activation$LogSigmoid)}
\item \code{"logsoftmax"} \cr \code{reticulate::py_help(torch$nn$modules$activation$LogSoftmax)}
\item \code{"prelu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$PReLU)}
\item \code{"rrelu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$RReLU)}
\item \code{"relu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$ReLU)}
\item \code{"selu"} \cr \code{reticulate::py_help(torch$nn$modules$activation$SELU)}
\item \code{"sigmoid"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Sigmoid)}
\item \code{"softmax"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Softmax)}
\item \code{"softmax2d"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Softmax2d)}
\item \code{"softmin"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Softmin)}
\item \code{"softplus"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Softplus)}
\item \code{"softshrink"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Softshrink)}
\item \code{"softsign"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Softsign)}
\item \code{"tanh"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Tanh)}
\item \code{"tanhshrink"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Tanhshrink)}
\item \code{"threshold"} \cr \code{reticulate::py_help(torch$nn$modules$activation$Threshold)}
}
}
\examples{
\donttest{
if (requireNamespaces("reticulate")) {
  #' # returns constructed objects
  get_pycox_activation(activation = "relu", construct = TRUE)

  # returns class
  get_pycox_activation(activation = "selu", construct = FALSE)
}
}

}
