% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_pycox.R
\name{predict.pycox}
\alias{predict.pycox}
\title{Predict Method for pycox Neural Networks}
\usage{
\method{predict}{pycox}(
  object,
  newdata,
  batch_size = 256L,
  num_workers = 0L,
  interpolate = FALSE,
  inter_scheme = c("const_hazard", "const_pdf"),
  sub = 10L,
  type = c("survival", "risk", "all"),
  distr6 = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{(pycox(1))}\cr
Object of class inheriting from \code{"pycox"}.}

\item{newdata}{\code{(data.frame(1))}\cr
Testing data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.
If missing then training data from fitted object is used.}

\item{batch_size}{\code{(integer(1))}\cr
Passed to \code{pycox.models.X.fit}, elements in each batch.}

\item{num_workers}{\code{(integer(1))}\cr
Passed to \code{pycox.models.X.fit}, number of workers used in the dataloader.}

\item{interpolate}{\code{(logical(1))}\cr
For models \code{deephit} and \code{loghaz}, should predictions be linearly interpolated? Ignored
for other models.}

\item{inter_scheme}{\code{(character(1))}\cr
If \code{interpolate} is \code{TRUE} then the scheme for interpolation, see
\code{reticulate::py_help(py_help(pycox$models$DeepHitSingle$interpolate))} for further
details.}

\item{sub}{\code{(integer(1))}\cr
If \code{interpolate} is \code{TRUE} or model is \code{loghaz}, number of sub-divisions for interpolation.
See reticulate::py_help(py_help(pycox$models$DeepHitSingle$interpolate))` for further
details.}

\item{type}{\code{(numeric(1))}\cr
Type of predicted value. Choices are survival probabilities over all time-points in training
data (\code{"survival"}) or a relative risk ranking (\code{"risk"}), which is the mean cumulative hazard
function over all time-points, or both (\code{"all"}).}

\item{distr6}{\code{(logical(1))}\cr
If \code{FALSE} (default) and \code{type} is \code{"survival"} or \code{"all"} returns matrix of survival
probabilities, otherwise returns a \code{\link[distr6:VectorDistribution]{distr6::VectorDistribution()}}.}

\item{...}{\code{ANY} \cr
Currently ignored.}
}
\value{
A \code{numeric} if \code{type = "risk"}, a \code{\link[distr6:VectorDistribution]{distr6::VectorDistribution()}} (if \code{distr6 = TRUE})
and \code{type = "survival"}; a \code{matrix} if (\code{distr6 = FALSE}) and \code{type = "survival"} where
entries are survival probabilities with rows of observations and columns are time-points;
or a list combining above if \code{type = "all"}.
}
\description{
Predicted values from a fitted pycox ANN.
}
\examples{
\donttest{
if (requireNamespaces("reticulate")) {
  fit <- coxtime(data = simsurvdata(50))

  # predict survival matrix and relative risks
  predict(fit, simsurvdata(10), type = "all")

  # return as distribution
  if (requireNamespaces("distr6")) {
    predict(fit, simsurvdata(10), distr6 = TRUE)
  }
}
}

}
