% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_question}
\alias{sd_question}
\title{Create a survey question}
\usage{
sd_question(
  type,
  id,
  label,
  cols = "80",
  direction = "horizontal",
  status = "default",
  width = "100\%",
  height = NULL,
  selected = NULL,
  label_select = "Choose an option...",
  grid = TRUE,
  individual = TRUE,
  justified = FALSE,
  force_edges = TRUE,
  option = NULL,
  placeholder = NULL,
  resize = NULL,
  row = NULL
)
}
\arguments{
\item{type}{Specifies the type of question. Possible values are "select", "mc",
"mc_multiple", "mc_buttons", "mc_multiple_buttons", "text", "textarea",
"numeric", "slider", "date", "daterange", and "matrix".}

\item{id}{A unique identifier for the question, which will be used as the variable name in the resulting survey data.}

\item{label}{Character string. The label for the UI element, which can be formatted with markdown.}

\item{cols}{Integer. Number of columns for the textarea input. Defaults to 80.}

\item{direction}{Character string. The direction for button groups ("horizontal" or "vertical"). Defaults to "horizontal".}

\item{status}{Character string. The status for button groups. Defaults to "default".}

\item{width}{Character string. The width of the UI element. Defaults to "100\%".}

\item{height}{Character string. The height of the textarea input. Defaults to "100px".}

\item{selected}{Value. The selected value(s) for certain input elements.}

\item{label_select}{Character string. The label for the select input. Defaults to "Choose an option...".}

\item{grid}{Logical. Whether to show a grid for slider input. Defaults to TRUE.}

\item{individual}{Logical. Whether buttons in a group should be individually styled. Defaults to TRUE.}

\item{justified}{Logical. Whether buttons in a group should fill the width of the parent div. Defaults to FALSE.}

\item{force_edges}{Logical. Whether to force edges for slider input. Defaults to TRUE.}

\item{option}{List. Options for the select, radio, checkbox, and slider inputs.}

\item{placeholder}{Character string. Placeholder text for text and textarea inputs.}

\item{resize}{Character string. Resize option for textarea input. Defaults to NULL.}

\item{row}{List. Used for "matrix" type questions. Contains the row labels and their corresponding IDs.}
}
\value{
A 'shiny' UI element wrapped in a div with a data attribute for
question ID.
}
\description{
This function creates various types of survey questions for use in a Surveydown survey.
}
\details{
The function supports various question types:
\itemize{
\item "select": A dropdown selection
\item "mc": Multiple choice (single selection)
\item "mc_multiple": Multiple choice (multiple selections allowed)
\item "mc_buttons": Multiple choice with button-style options (single selection)
\item "mc_multiple_buttons": Multiple choice with button-style options (multiple selections allowed)
\item "text": Single-line text input
\item "textarea": Multi-line text input
\item "numeric": Numeric input
\item "slider": Slider input
\item "date": Date input
\item "daterange": Date range input
\item "matrix": Matrix-style question with rows and columns
}

For "matrix" type questions, use the \code{row} parameter to define the rows of
the matrix. Each element in the \code{row} list should have a name (used as the
row ID) and a value (used as the row label).
}
\examples{
if (interactive()) {
  library(surveydown)

  # Get path to example survey file
  survey_path <- system.file("examples", "basic_survey.qmd",
                             package = "surveydown")

  # Copy to a temporary directory
  temp_dir <- tempdir()
  file.copy(survey_path, file.path(temp_dir, "survey.qmd"))
  orig_dir <- getwd()
  setwd(temp_dir)

  # Define a minimal server
  server <- function(input, output, session) {
    sd_server()
  }

  # Run the app
  shiny::shinyApp(ui = sd_ui(), server = server)

  # Clean up
  setwd(orig_dir)
}

}
