% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{sd_db_connect}
\alias{sd_db_connect}
\title{Connect to database}
\usage{
sd_db_connect(env_file = ".env", ignore = FALSE, gssencmode = "prefer")
}
\arguments{
\item{env_file}{Character string. Path to the env file. Defaults to ".env"}

\item{ignore}{Logical. If \code{TRUE}, data will be saved to a local CSV file
instead of the database. Defaults to \code{FALSE}.}

\item{gssencmode}{Character string. The GSS encryption mode for the database
connection. Defaults to \code{"prefer"}. NOTE: If you have verified all
connection details are correct but still cannot access the database,
consider setting this to \code{"disable"}. This can be necessary if you're on a
secure connection, such as a VPN.}
}
\value{
A list containing the database connection pool (\code{db}) and table name (\code{table}),
or \code{NULL} if ignore is \code{TRUE} or if connection fails
}
\description{
Establish a connection to the database using settings from .env file. This function
creates a connection pool for efficient database access and provides options for
local data storage when needed.
}
\examples{
if (interactive()) {
  # Connect using settings from .env
  db <- sd_db_connect()

  # Use local storage instead of database
  db <- sd_db_connect(ignore = TRUE)

  # Close connection when done
  if (!is.null(db)) {
    pool::poolClose(db$db)
  }
}

}
