% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_profile.R
\name{model_profile}
\alias{model_profile}
\alias{model_profile.surv_explainer}
\title{Dataset Level Variable Profile as Partial Dependence Explanations for Survival Models}
\usage{
model_profile(
  explainer,
  variables = NULL,
  N = 100,
  ...,
  groups = NULL,
  k = NULL,
  type = "partial",
  center = FALSE,
  output_type = "survival"
)

\method{model_profile}{surv_explainer}(
  explainer,
  variables = NULL,
  N = 100,
  ...,
  categorical_variables = NULL,
  grid_points = 51,
  variable_splits_type = "uniform",
  groups = NULL,
  k = NULL,
  center = FALSE,
  type = "partial",
  output_type = "survival"
)
}
\arguments{
\item{explainer}{an explainer object - model preprocessed by the \code{explain()} function}

\item{variables}{character, a vector of names of variables to be explained}

\item{N}{number of observations used for the calculation of aggregated profiles. By default \code{100}. If \code{NULL} all observations are used.}

\item{...}{other parameters passed to \code{DALEX::model_profile} if \code{output_type == "risk"}, otherwise ignored}

\item{groups}{if \code{output_type == "risk"} a variable name that will be used for grouping. By default \code{NULL}, so no groups are calculated. If \code{output_type == "survival"} then ignored}

\item{k}{passed to \code{DALEX::model_profile} if \code{output_type == "risk"}, otherwise ignored}

\item{type}{the type of variable profile, \code{"partial"} for Partial Dependence, \code{"accumulated"} for Accumulated Local Effects, or \code{"conditional"} (available only for \code{output_type == "risk"})}

\item{center}{logical, should profiles be centered around the average prediction}

\item{output_type}{either \code{"survival"}, \code{"chf"} or \code{"risk"} the type of survival model output that should be considered for explanations. If \code{"survival"} the explanations are based on the survival function. If \code{"chf"} the explanations are based on the cumulative hazard function. Otherwise the scalar risk predictions are used by the \code{DALEX::predict_profile} function.}

\item{categorical_variables}{character, a vector of names of additional variables which should be treated as categorical (factors are automatically treated as categorical variables). If it contains variable names not present in the \code{variables} argument, they will be added at the end.}

\item{grid_points}{maximum number of points for profile calculations. Note that the final number of points may be lower than grid_points. Will be passed to internal function. By default \code{51}.}

\item{variable_splits_type}{character, decides how variable grids should be calculated. Use \code{"quantiles"} for percentiles or \code{"uniform"} (default) to get uniform grid of points.}
}
\value{
An object of class \code{model_profile_survival}. It is a list with the element \code{result} containing the results of the calculation.
}
\description{
This function calculates explanations on a dataset level that help explore model response as a function of selected variables.
The explanations are calculated as an extension of Partial Dependence Profiles with the inclusion of the time dimension.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
rsf_src <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)

cph_exp <- explain(cph)
rsf_src_exp <- explain(rsf_src)

cph_model_profile <- model_profile(cph_exp,
    output_type = "survival",
    variables = c("age")
)

head(cph_model_profile$result)

plot(cph_model_profile)

rsf_model_profile <- model_profile(rsf_src_exp,
    output_type = "survival",
    variables = c("age", "celltype"),
    type = "accumulated"
)

head(rsf_model_profile$result)

plot(rsf_model_profile, variables = c("age", "celltype"), numerical_plot_type = "contours")
}

}
