% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_integrated_feature_importance.R
\name{surv_integrated_feature_importance}
\alias{surv_integrated_feature_importance}
\title{Helper functions for \code{model_parts.R}}
\usage{
surv_integrated_feature_importance(
  x,
  loss_function = DALEX::loss_root_mean_square,
  ...,
  type = c("raw", "ratio", "difference"),
  B = 10,
  variables = NULL,
  variable_groups = NULL,
  N = NULL,
  label = NULL
)
}
\arguments{
\item{x}{an explainer object - model preprocessed by the \code{explain()} function}

\item{loss_function}{a function that will be used to assess variable importance, by default \code{loss_brier_score} for survival models. The function should take can be supplied manually but has to have these named parameters (\code{y_true}, \code{risk}, \code{surv}, \code{times}), where \code{y_true} represents the \code{survival::Surv} object with observed times and statuses, \code{risk} is the risk score calculated by the model, and \code{surv} is the survival function for each observation evaluated at \code{times}}

\item{...}{other parameters, currently ignored}

\item{type}{a character vector, if \code{"raw"} the results are losses after the permutation, if \code{"ratio"} the results are in the form \code{loss/loss_full_model} and if \code{"difference"} the results are of the form loss - loss_full_model`}

\item{B}{numeric, number of permutations to be calculated}

\item{variables}{a character vector, names of variables to be included in the calculation}

\item{variable_groups}{a list of character vectors of names of explanatory variables. For each vector, a single variable-importance measure is computed for the joint effect of the variables which names are provided in the vector. By default, variable_groups = NULL, in which case variable-importance measures are computed separately for all variables indicated in the variables argument}

\item{N}{numeric, number of observations that are to be sampled from the dataset for the purpose of calculation}

\item{label}{label of the model, if provides overrides x$label}
}
\value{
A data.frame containing results of the calculation.
}
\description{
This function is used to calculate permutational feature importance using
an aggregate (for now only integral) of a time dependent metric. The result is
the combined change in loss function across all time points - a single value.
}
\details{
\emph{Note}: This function can be run within \code{progressr::with_progress()} to display a progress bar, as the execution can take long, especially on large datasets.
}
\keyword{internal}
