% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predict_parts_survival.R
\name{plot.predict_parts_survival}
\alias{plot.predict_parts_survival}
\title{Plot Predict Parts for Survival Models}
\usage{
\method{plot}{predict_parts_survival}(x, ...)
}
\arguments{
\item{x}{an object of class  \code{"predict_parts_survival"} to be plotted}

\item{...}{additional parameters passed to the \code{plot.surv_shap} or \code{plot.surv_lime} functions}
}
\value{
An object of the class \code{ggplot}.
}
\description{
This function plots objects of class \code{"predict_parts_survival"} - local explanations
for survival models created using the \code{predict_parts()} function.
}
\section{Plot options}{

\subsection{\code{plot.surv_shap}}{
\itemize{
\item \code{x} - an object of class \code{"surv_shap"} to be plotted
\item \code{...} - additional objects of class \code{surv_shap} to be plotted together
\item \code{title} - character, title of the plot
\item \code{subtitle} - character, subtitle of the plot, \code{'default'} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels
\item \code{colors} - character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")
}
}

\subsection{\code{plot.surv_lime}}{
\itemize{
\item \code{x} -  an object of class \code{"surv_lime"} to be plotted
\item \code{type} -  character, either "coefficients" or "local_importance", selects the type of plot
\item \code{show_survival_function} -  logical, if the survival function of the explanations should be plotted next to the barplot
\item \code{...} -  other parameters currently ignored
\item \code{title} -  character, title of the plot
\item \code{subtitle} -  character, subtitle of the plot, \code{'default'} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels
\item \code{colors} -  character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")
}
}
}

\examples{
\donttest{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

p_parts_shap <- predict_parts(exp, veteran[1, -c(3, 4)], type = "survshap")
plot(p_parts_shap)

p_parts_lime <- predict_parts(exp, veteran[1, -c(3, 4)], type = "survlime")
plot(p_parts_lime)
}
}
\seealso{
Other functions for plotting 'predict_parts_survival' objects: 
\code{\link{plot.surv_lime}()},
\code{\link{plot.surv_shap}()}
}
\concept{functions for plotting 'predict_parts_survival' objects}
