% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{integrated_brier_score}
\alias{integrated_brier_score}
\alias{loss_integrated_brier_score}
\title{Calculate integrated Brier score}
\usage{
integrated_brier_score(
  y_true = NULL,
  risk = NULL,
  surv = NULL,
  times = NULL,
  brier = NULL
)

loss_integrated_brier_score(
  y_true = NULL,
  risk = NULL,
  surv = NULL,
  times = NULL,
  brier = NULL
)
}
\arguments{
\item{y_true}{a \code{survival::Surv} object containing the times and statuses of observations for which the metric will be evaluated}

\item{risk}{ignored, left for compatibility with other metrics}

\item{surv}{a matrix containing the predicted survival functions for the considered observations, each row represents a single observation, whereas each column one time point}

\item{times}{a vector of time points at which the survival function was evaluated}

\item{brier}{a vector containing already calculated Brier score metric at the time points specified in the times parameter. If this is provided all arguments except \code{times} and \code{brier} are ignored}
}
\value{
numeric from 0 to 1, lower values indicate better performance
}
\description{
This function calculates the integrated Brier score metric for a survival model.
}
\details{
It is useful to see how a model performs as a whole, not at specific time points, for example for easier comparison. This function allows for calculating the integral of Brier score metric numerically using the trapezoid method.
}
\examples{

library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

y <- cph_exp$y
times <- cph_exp$times
surv <- cph_exp$predict_survival_function(cph, cph_exp$data, times)


# calculating directly
integrated_brier_score(y, surv = surv, times = times)

# calculating based on given auc vector
brier_score <- brier_score(y, surv = surv, times = times)
integrated_brier_score(times = times, brier = brier_score)

}
\seealso{
\code{\link[=brier_score]{brier_score()}} \code{\link[=integrated_cd_auc]{integrated_cd_auc()}} \code{\link[=loss_one_minus_integrated_cd_auc]{loss_one_minus_integrated_cd_auc()}}
}
