\name{sts_animate}
\alias{animate.sts}
\title{
  Animated Maps and Time Series of Disease Incidence
}

\description{
  The \code{animate}-method for \code{\linkS4class{sts}} objects
  supersedes the \code{\link{stsplot}} type \code{observed~1|unit*time}
  implemented by the function \code{\link{stsplot_spacetime}}.
  Maps generated by \code{\link{stsplot_space}} are
  sequentially plotted along time (optionally showing cumulative
  counts), with an optional time series chart below the map to track the
  epidemic curve.
  It is worth using functionality of the \pkg{animation} package
  (e.g., \code{\link[animation]{saveHTML}}) to directly export the
  animation into a useful format.
  See Meyer and Held (2014, Supplement A) for an example with the
  \code{\link{fluBYBW}} data.
}

\usage{
\method{animate}{sts}(object, tps = NULL, cumulative = FALSE,
        population = NULL, at = 10, ...,
        timeplot = list(height = 0.3), sleep = 0.5, verbose = interactive())
}

\arguments{
  \item{object}{
    an object of class \code{"\linkS4class{sts}"} or a matrix of counts,
    i.e., \code{observed(stsObj)}, where especially
    \code{colnames(x)} have to be contained in \code{row.names(map)}.
    If a matrix, the \code{map} object has to be provided explicitly (as
    part of \code{\dots}).
  }
  \item{tps}{
    a numeric vector of one or more time points at which to plot the map.
    The default \code{tps=NULL} means the whole time period \code{1:nrow(object)}.
  }
  \item{cumulative}{
    logical specifying if the cumulative counts over time should be plotted.
  }
  \item{population,at,\dots}{
    arguments for \code{\link{stsplot_space}}.
  }
  \item{timeplot}{
    if a list (of arguments for the internal function
    \code{stsplot_timeSimple}), a time series chart of the counts along
    the selected time points \code{tps} will be plotted below the map.
    The argument \code{height} gives the relative height of the time
    series plot (default: 0.3), and the arguments \code{inactive} and
    \code{active} are lists of graphical parameters (e.g., \code{col})
    determining the appearance of the bars (e.g., default color is grey
    when inactive and black when active).
  }
  \item{sleep}{
    time to wait (\code{Sys.sleep}) between subsequent snapshots (only if
    \code{\link{dev.interactive}}), in seconds.
  }
  \item{verbose}{
    logical indicating if a \code{\link{txtProgressBar}} should be shown
    during generation of the animation -- which may take a while.
    Default is to do so in \code{\link{interactive}} sessions.
  }
}

\value{
  \code{NULL} (invisibly)
}

\references{
  Meyer, S. and Held, L. (2014):
  Power-law models for infectious disease spread.
  \emph{The Annals of Applied Statistics}, \bold{8} (3), 1612-1639.\cr
  DOI-Link: \url{http://dx.doi.org/10.1214/14-AOAS743}\cr
  Supplement A is available from
  \url{http://www.biostat.uzh.ch/static/powerlaw/}.
}

\author{
  Sebastian Meyer
}

\seealso{
  the other plot types documented in \code{\link{stsplot}} for static
  time series plots and maps.
}

\examples{
data("measlesWeserEms")

## sequential plot of the counts by region in weeks 12-16 only (for speed)
if (require("animation")) {
    oldwd <- setwd(tempdir())  # to not clutter up the current working dir
    saveHTML(animate(measlesWeserEms, tps=12:16, cumulative=FALSE),
             title="Evolution of the measles epidemic in the Weser-Ems region",
             ani.width=500, ani.height=600)
    setwd(oldwd)
}
}

\keyword{hplot}
\keyword{dynamic}
\keyword{spatial}
