% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{gof}
\alias{gof}
\alias{gof.default}
\alias{plot.gof}
\title{Goodness-of-Fit Simulation}
\usage{
gof(object, nsim = 10, test = c("ks", "ad", "cvm"), ...)

\method{gof}{default}(object, nsim = 10, test = c("ks", "ad", "cvm"), ...)

\method{plot}{gof}(x, ...)
}
\arguments{
\item{object}{An object of class \code{\link[ordinal]{clm}},
\code{\link[stats]{glm}}, \code{\link[rms]{lrm}}, \code{\link[rms]{orm}},
\code{\link[MASS]{polr}}, or \code{\link[VGAM]{vglm}}.}

\item{nsim}{Integer specifying the number of bootstrap replicates to use.}

\item{test}{Character string specifying which goodness-of-fit test to use.
Current options include: \code{"ks"} for the Kolmogorov-Smirnov test,
\code{"ad"} for the Anderson-Darling test, and \code{"cvm"} for the
Cramer-Von Mises test. Default is \code{"ks"}.}

\item{...}{Additional optional arguments. (Currently ignored.)}

\item{x}{An object of class \code{"gof"}.}
}
\value{
A numeric vector of class \code{"gof", "numeric"} containing the
simulated p-values.
}
\description{
Simulate p-values from a goodness-of-fit test.
}
\details{
Under the null hypothesis, the distribution of the p-values should appear
uniformly distributed on the interval [0, 1]. This can be visually
investigated using the \code{plot} method. A 45 degree line is indicative of
a "good" fit.
}
\examples{
# See ?resids for an example
?resids
}
