#' Simulated Quadratic Data
#'
#' Data simulated from a probit model with a quadratic trend. The data are
#' described in Example 2 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{x} The predictor variable.
#'   \item \code{y} The response variable; an ordered factor.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df1
#'
#' @usage
#' data(df1)
#'
#' @examples
#' head(df1)
NULL


#' Simulated Heteroscedastic Data
#'
#' Data simulated from a probit model with heteroscedasticity. The data are
#' described in Example 4 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{x} The predictor variable.
#'   \item \code{y} The response variable; an ordered factor.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df2
#'
#' @usage
#' data(df2)
#'
#' @examples
#' head(df2)
NULL


#' Simulated Gumbel Data
#'
#' Data simulated from a log-log model with a quadratic trend. The data are
#' described in Example 3 of Liu and Zhang (2017).
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @format A data frame with 2000 rows and 2 variables.
#' \itemize{
#'   \item \code{x} The predictor variable.
#'   \item \code{y} The response variable; an ordered factor.
#' }
#'
#' @references
#' Liu, Dungang and Zhang, Heping. Residuals and Diagnostics for Ordinal
#' Regression Models: A Surrogate Approach.
#' \emph{Journal of the American Statistical Association} (accepted).
#'
#' @name df3
#'
#' @usage
#' data(df3)
#'
#' @examples
#' head(df3)
NULL
