% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_check.R
\name{date_check}
\alias{date_check}
\title{Check a Column for Non-Dates}
\usage{
date_check(data = NULL, col = NULL)
}
\arguments{
\item{data}{(dataframe) object containing at least one column of supposed dates}

\item{col}{(character or numeric) name or column number of the column containing putative dates in the data object}
}
\value{
(character) vector of malformed dates
}
\description{
Any elements in the column that would be changed to NA if \code{as.Date} is used on the column are returned. This is useful for quickly identifying only the "problem" entries of an ostensibly date column that is read in as a character.
}
\examples{
# Let's create some data that will be useful in demoing this function
loc <- c("LTR", "GIL", "PYN", "RIN")
time <- c('2021-01-01', '2021-01-0w', '1990', '2020-10-xx')
sites <- data.frame('site' = loc, 'visit' = time)

# Now we can use our function to identify bad dates
date_check(data = sites, col = 'visit')
}
