% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TfidfVectorizer.R
\name{TfIdfVectorizer}
\alias{TfIdfVectorizer}
\title{TfIDF(Term Frequency Inverse Document Frequency) Vectorizer}
\description{
Creates a tf-idf matrix
}
\details{
Given a list of text, it creates a sparse matrix consisting of tf-idf score for tokens from the text.
}
\examples{

## ------------------------------------------------
## Method `TfIdfVectorizer$new`
## ------------------------------------------------

TfIdfVectorizer$new()

## ------------------------------------------------
## Method `TfIdfVectorizer$fit`
## ------------------------------------------------

sents = c('i am alone in dark.','mother_mary a lot',
          'alone in the dark?', 'many mothers in the lot....')
tf = TfIdfVectorizer$new(smooth_idf = TRUE, min_df = 0.3)
tf$fit(sents)

## ------------------------------------------------
## Method `TfIdfVectorizer$fit_transform`
## ------------------------------------------------

\dontrun{
sents <- c('i am alone in dark.','mother_mary a lot',
         'alone in the dark?', 'many mothers in the lot....')
tf <- TfIdfVectorizer$new(smooth_idf = TRUE, min_df = 0.1)
tf_matrix <- tf$fit_transform(sents)
}

## ------------------------------------------------
## Method `TfIdfVectorizer$transform`
## ------------------------------------------------

\dontrun{
sents = c('i am alone in dark.','mother_mary a lot',
          'alone in the dark?', 'many mothers in the lot....')
new_sents <- c("dark at night",'mothers day')
tf = TfIdfVectorizer$new(min_df=0.1)
tf$fit(sents)
tf_matrix <- tf$transform(new_sents)
}
}
\section{Super class}{
\code{\link[superml:CountVectorizer]{superml::CountVectorizer}} -> \code{TfIdfVectorizer}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sentences}}{a list containing sentences}

\item{\code{max_df}}{When building the vocabulary ignore terms that have a document frequency strictly higher than the given threshold, value lies between 0 and 1.}

\item{\code{min_df}}{When building the vocabulary ignore terms that have a document frequency strictly lower than the given threshold, value lies between 0 and 1.}

\item{\code{max_features}}{use top features sorted by count to be used in bag of words matrix.}

\item{\code{ngram_range}}{The lower and upper boundary of the range of n-values for different word n-grams or char n-grams to be extracted. All values of n such such that min_n <= n <= max_n will be used. For example an ngram_range of c(1, 1) means only unigrams, c(1, 2) means unigrams and bigrams, and c(2, 2) means only bigrams.}

\item{\code{split}}{splitting criteria for strings, default: " "}

\item{\code{lowercase}}{convert all characters to lowercase before tokenizing}

\item{\code{regex}}{regex expression to use for text cleaning.}

\item{\code{remove_stopwords}}{a list of stopwords to use, by default it uses its inbuilt list of standard stopwords}

\item{\code{smooth_idf}}{logical, to prevent zero division, adds one to document frequencies, as if an extra document was seen containing every term in the collection exactly once}

\item{\code{norm}}{logical, if TRUE, each output row will have unit norm ‘l2’: Sum of squares of vector elements is 1. if FALSE returns non-normalized vectors, default: TRUE}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TfIdfVectorizer$new()}}
\item \href{#method-fit}{\code{TfIdfVectorizer$fit()}}
\item \href{#method-fit_transform}{\code{TfIdfVectorizer$fit_transform()}}
\item \href{#method-transform}{\code{TfIdfVectorizer$transform()}}
\item \href{#method-clone}{\code{TfIdfVectorizer$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TfIdfVectorizer$new(
  min_df,
  max_df,
  max_features,
  ngram_range,
  regex,
  remove_stopwords,
  split,
  lowercase,
  smooth_idf,
  norm
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_df}}{numeric, When building the vocabulary ignore terms that have a document frequency strictly lower than the given threshold, value lies between 0 and 1.}

\item{\code{max_df}}{numeric, When building the vocabulary ignore terms that have a document frequency strictly higher than the given threshold, value lies between 0 and 1.}

\item{\code{max_features}}{integer, Build a vocabulary that only consider the top max_features ordered by term frequency across the corpus.}

\item{\code{ngram_range}}{vector, The lower and upper boundary of the range of n-values for different word n-grams or char n-grams to be extracted. All values of n such such that min_n <= n <= max_n will be used. For example an ngram_range of c(1, 1) means only unigrams, c(1, 2) means unigrams and bigrams, and c(2, 2) means only bigrams.}

\item{\code{regex}}{character, regex expression to use for text cleaning.}

\item{\code{remove_stopwords}}{list, a list of stopwords to use, by default it uses its inbuilt list of standard english stopwords}

\item{\code{split}}{character, splitting criteria for strings, default: " "}

\item{\code{lowercase}}{logical, convert all characters to lowercase before tokenizing, default: TRUE}

\item{\code{smooth_idf}}{logical, to prevent zero division, adds one to document frequencies, as if an extra document was seen containing every term in the collection exactly once}

\item{\code{norm}}{logical, if TRUE, each output row will have unit norm ‘l2’: Sum of squares of vector elements is 1. if FALSE returns non-normalized vectors, default: TRUE}

\item{\code{parallel}}{logical,  speeds up ngrams computation using n-1 cores, defaults: TRUE}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new `TfIdfVectorizer` object.
}

\subsection{Returns}{
A `TfIdfVectorizer` object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{TfIdfVectorizer$new()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TfIdfVectorizer$fit(sentences)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sentences}}{a list of text sentences}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fits the TfIdfVectorizer model on sentences
}

\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sents = c('i am alone in dark.','mother_mary a lot',
          'alone in the dark?', 'many mothers in the lot....')
tf = TfIdfVectorizer$new(smooth_idf = TRUE, min_df = 0.3)
tf$fit(sents)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TfIdfVectorizer$fit_transform(sentences)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sentences}}{a list of text sentences}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Fits the TfIdfVectorizer model and returns a sparse matrix of count of tokens
}

\subsection{Returns}{
a sparse matrix containing tf-idf score for tokens in each given sentence
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sents <- c('i am alone in dark.','mother_mary a lot',
         'alone in the dark?', 'many mothers in the lot....')
tf <- TfIdfVectorizer$new(smooth_idf = TRUE, min_df = 0.1)
tf_matrix <- tf$fit_transform(sents)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TfIdfVectorizer$transform(sentences)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sentences}}{a list of new text sentences}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns a matrix of tf-idf score of tokens
}

\subsection{Returns}{
a sparse matrix containing tf-idf score for tokens in each given sentence
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
sents = c('i am alone in dark.','mother_mary a lot',
          'alone in the dark?', 'many mothers in the lot....')
new_sents <- c("dark at night",'mothers day')
tf = TfIdfVectorizer$new(min_df=0.1)
tf$fit(sents)
tf_matrix <- tf$transform(new_sents)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TfIdfVectorizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
