% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercells.R
\name{supercells}
\alias{supercells}
\title{Creates supercells}
\usage{
supercells(
  x,
  k,
  compactness,
  dist_fun = "euclidean",
  avg_fun = "mean",
  clean = TRUE,
  iter = 10,
  transform = NULL,
  step,
  minarea,
  metadata = TRUE,
  chunks = FALSE,
  future = FALSE,
  verbose = 0
)
}
\arguments{
\item{x}{An object of class SpatRaster (terra) or class stars (stars)}

\item{k}{The number of supercells desired by the user (the output number can be slightly different!).
You can use either \code{k} or \code{step}.
It is also possible to provide a set of points (an \code{sf} object) as \code{k} together with the \code{step} value to create custom cluster centers.}

\item{compactness}{A compactness value. Larger values cause clusters to be more compact/even (square).
A compactness value depends on the range of input cell values and selected distance measure.}

\item{dist_fun}{A distance function. Currently implemented distance functions are \code{"euclidean"}, \code{"jsd"}, \code{"dtw"} (dynamic time warping), name of any distance function from the \code{philentropy} package (see \code{\link[philentropy:getDistMethods]{philentropy::getDistMethods()}}; "log2" is used in this case), or any user defined function accepting two vectors and returning one value. Default: \code{"euclidean"}}

\item{avg_fun}{An averaging function - how the values of the supercells' centers are calculated?
It accepts any fitting R function (e.g., \code{base::mean()} or \code{stats::median()}) or one of internally implemented \code{"mean"} and \code{"median"}. Default: \code{"mean"}}

\item{clean}{Should connectivity of the supercells be enforced?}

\item{iter}{The number of iterations performed to create the output.}

\item{transform}{Transformation to be performed on the input. By default, no transformation is performed. Currently available transformation is "to_LAB": first, the conversion from RGB to the LAB color space is applied, then the supercells algorithm is run, and afterward, a reverse transformation is performed on the obtained results. (This argument is experimental and may be removed in the future).}

\item{step}{The distance (number of cells) between initial supercells' centers. You can use either \code{k} or \code{step}.}

\item{minarea}{Specifies the minimal size of a supercell (in cells). Only works when \code{clean = TRUE}.
By default, when \code{clean = TRUE}, average area (A) is calculated based on the total number of cells divided by a number of supercells
Next, the minimal size of a supercell equals to A/(2^2) (A is being right shifted)}

\item{metadata}{Logical. If \code{TRUE}, the output object will have metadata columns ("supercells", "x", "y"). If \code{FALSE}, the output object will not have metadata columns.}

\item{chunks}{Should the input (\code{x}) be split into chunks before deriving supercells? Either \code{FALSE} (default), \code{TRUE} (only large input objects are split), or a numeric value (representing the side length of the chunk in the number of cells).}

\item{future}{Should the future package be used for parallelization of the calculations? Default: \code{FALSE}. If \code{TRUE}, you also need to specify \code{future::plan()}.}

\item{verbose}{An integer specifying the level of text messages printed during calculations. 0 means no messages (default), 1 provides basic messages (e.g., calculation stage).}
}
\value{
An sf object with several columns: (1) supercells - an id of each supercell, (2) y and x coordinates, (3) one or more columns with average values of given variables in each supercell
}
\description{
Creates supercells based on single- or multi-band spatial raster data. It uses a modified version of the SLIC Superpixel algorithm by Achanta et al. (2012), allowing specification of a distance function.
}
\examples{
library(supercells)
# One variable

vol = terra::rast(system.file("raster/volcano.tif", package = "supercells"))
vol_slic1 = supercells(vol, k = 50, compactness = 1)
terra::plot(vol)
plot(sf::st_geometry(vol_slic1), add = TRUE, lwd = 0.2)

# RGB variables
# ortho = terra::rast(system.file("raster/ortho.tif", package = "supercells"))
# ortho_slic1 = supercells(ortho, k = 1000, compactness = 10, transform = "to_LAB")
# terra::plot(ortho)
# plot(sf::st_geometry(ortho_slic1), add = TRUE)
#
# ### RGB variables - colored output
#
# rgb_to_hex = function(x){
#   apply(t(x), 2, function(x) rgb(x[1], x[2], x[3], maxColorValue = 255))
# }
# avg_colors = rgb_to_hex(sf::st_drop_geometry(ortho_slic1[4:6]))
#
# terra::plot(ortho)
# plot(sf::st_geometry(ortho_slic1), add = TRUE, col = avg_colors)
}
\references{
Achanta, R., Shaji, A., Smith, K., Lucchi, A., Fua, P., & Süsstrunk, S. (2012). SLIC Superpixels Compared to State-of-the-Art Superpixel Methods. IEEE Transactions on Pattern Analysis and Machine Intelligence, 34(11), 2274–2282. https://doi.org/10.1109/tpami.2012.120

Nowosad, J. Motif: an open-source R tool for pattern-based spatial analysis. Landscape Ecol (2021). https://doi.org/10.1007/s10980-020-01135-0
}
