% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_crit1_cutoff.R
\name{define_crit1_cutoff}
\alias{define_crit1_cutoff}
\title{Define cut-off value for first SG criterion}
\usage{
define_crit1_cutoff(
  sd = NULL,
  reliability = NULL,
  data_sd = NULL,
  data_reliability = NULL
)
}
\arguments{
\item{sd}{Numeric, standard deviation of normal population or standard deviation at baseline.
This argument is not needed if a vector with pretreatment scores is specified in the \code{data_sd} argument.}

\item{reliability}{Numeric, between 0 and 1 indicating reliability of the scale.
This argument is not needed if item-by-item data is specified in the \code{data_reliability} argument.}

\item{data_sd}{A vector with pretreatment values.
This argument is not needed if the standard deviation is specified in the \code{sd} argument.}

\item{data_reliability}{A dataset in wide format (one row for each individual and one column for each item) including only the item-by-item scores of the SG measure (no ID variable).
According to Jacobson & Truax (1991) the test-retest reliability should be used.
Martinovich et al. (1996) suggest that the internal consistency (Cronbach's alpha) can be used instead of the test-retest reliability and may be more appropriate for estimating the standard error in some cases.
This argument is not needed if the reliability is specified in the \code{reliability} argument.}
}
\value{
A list with estimates the for standard error of measurement (se), the standard error of the difference (sdiff) and a value that classifies as reliable change (reliable_change_value).
}
\description{
Define a cut-off value for the first sudden gains criterion based on the Reliable Change Index (RCI; Jacobson & Truax, 1991) using an estimate for the standard deviation (sd) of the normal population and the reliability of the scale.
These values can be entered manually using the arguments \code{sd} and \code{reliability} or extracted from data using the arguments \code{data_sd} and \code{data_reliability}.
This function calculates the standard error of measurement (se), the standard error of the difference (sdiff) and a value that classifies as reliable change (reliable_change_value) based on the Reliable Change Index (RCI; Jacobson & Truax, 1991).
\deqn{se = sd * \sqrt{(1 - reliability)}}
\deqn{sdiff = \sqrt{(2 * se^2)}}
\deqn{reliable change value = 1.96 * sdiff}
}
\examples{
# Define cut-off value for first SG criterion
# In this example the standard deviation and the reliability are specified manually
define_crit1_cutoff(sd = 10.5,
                    reliability = 0.931)

# In this example the reliability is specified manually
# The standard deviation of the variable "bdi_s0" in the dataset "sgdata" gets calculated
define_crit1_cutoff(data_sd = sgdata$bdi_s0,
                    reliability = 0.931)
}
\references{
Jacobson, N. S., & Truax, P. A. (1991). Clinical significance: A statistical approach to defining meaningful change in psychotherapy research. Journal of Consulting and Clinical Psychology, 59 (1), 12-19. \url{https://doi.org/10.1037/0022-006X.59.1.12}.

Martinovich, Z., Saunders, S., & Howard, K. (1996). Some Comments on “Assessing Clinical Significance”. Psychotherapy Research, 6(2), 124–132. \url{https://doi.org/10.1080/10503309612331331648}.

Stiles et al. (2003). Early sudden gains in psychotherapy under routine clinic conditions: Practice-based evidence. Journal of Consulting and Clinical Psychology, 71 (1), 14-21. \url{https://doi.org/10.1037/0022-006X.71.1.14}.
}
