% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot.R
\name{subplot}
\alias{subplot}
\title{Sub-community plot under each sub-environmental space K}
\usage{
subplot(subnic, main=NULL, xlab=NULL, ylab=NULL, col.axis="azure3", lty.axis=2,
       lwd.axis=2, col.sublab="black", font.sublab=2, cex.sublab=0.7, show.lines=F,
       border.E="#92c5de", col.E="#92c5de", lty.E=1, lwd.E=1, border.K ="#2c7fb8",
       col.K ="#2c7fb8", lty.K=1, lwd.K=1, col.arrow="black", angle.arrow=20, lwd.arrow=2,
       length.arrow=0.1, col.G_k= "#b35806", cex.G_k=0.5, pch.G_k=19,
       col.su="#b35806", cex.su=0.5, pch.su=1, posi.leg="topleft", bty.leg="n", ...)
}
\arguments{
\item{subnic}{an object of class \code{subniche}.}

\item{main}{a main title for the plot, see \link[graphics]{title} for more details.}

\item{xlab}{a label for the x axis, defaults to a description of x, see \link[graphics]{title} for more details.}

\item{ylab}{a label for the y axis, defaults to a description of y, see \link[graphics]{title} for more details.}

\item{col.axis}{axis color, see \link[graphics]{par} for more details.}

\item{lty.axis}{axis line type, see \link[graphics]{par} for more details.}

\item{lwd.axis}{axis width, see \link[graphics]{par} for more details.}

\item{col.sublab}{color of the species labels, see \link[wordcloud]{textplot} for more details.}

\item{font.sublab}{font of the species labels, see \link[wordcloud]{textplot} for more details.}

\item{cex.sublab}{size of the species labels, see \link[wordcloud]{textplot} for more details.}

\item{show.lines}{if true, then lines are plotted between x,y and the word, for those words not covering their x,y coordinates. See \link[wordcloud]{textplot} for more details.}

\item{border.E}{color border of E polygon, see \link[graphics]{polygon} for more details.}

\item{col.E}{inside color of E polygon, see \link[graphics]{polygon} for more details.}

\item{lty.E}{line type for the E border, see \link[graphics]{polygon} for more details.}

\item{lwd.E}{line width for the E border, see \link[graphics]{polygon} for more details.}

\item{border.K}{color border of K polygon, see \link[graphics]{polygon} for more details.}

\item{col.K}{inside color of K polygon, see \link[graphics]{polygon} for more details.}

\item{lty.K}{line type for the K border, see \link[graphics]{polygon} for more details.}

\item{lwd.K}{line width for the K border, see \link[graphics]{polygon} for more details.}

\item{col.arrow}{arrow color, see \link[graphics]{arrows} for more details.}

\item{angle.arrow}{arrow angle head, see \link[graphics]{arrows} for more details.}

\item{lwd.arrow}{arrow width, see \link[graphics]{arrows} for more details.}

\item{length.arrow}{arrow head length, see \link[graphics]{arrows} for more details.}

\item{col.G_k}{color of the point representing G_k, see \link[graphics]{points} for more details.}

\item{cex.G_k}{size of the point representing G_k, see \link[graphics]{points} for more details.}

\item{pch.G_k}{type of the point representing G_k, see \link[graphics]{points} for more details.}

\item{col.su}{color of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{cex.su}{size of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{pch.su}{type of the points representing the sampling units (SU), see \link[graphics]{points} for more details.}

\item{posi.leg}{legend location in the graph, see \link[graphics]{legend} for more details.}

\item{bty.leg}{the type of box to be drawn around the legends. The allowed values are "o" (the default) and "n". See \link[graphics]{legend} for more details}

\item{...}{further arguments passed to or from other methods.}
}
\description{
The function to represent the community subniche position under each subenvironment K with their respective marginality from G_K.
}
\examples{
library(subniche)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subsets
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
eig <- round(subnic1$eig/sum(subnic1$eig)*100,2)[1:2]
#Two graphs are drawn one after the other
subplot(subnic1,main="Species subniche in K",
xlab=paste(paste("OMI1", eig[1], sep=" "),"\%", sep=""),
ylab=paste(paste("OMI2", eig[2], sep=" "),"\%", sep=""))

}
