% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_speaker_odds.R
\name{stylest_odds}
\alias{stylest_odds}
\title{Pairwise prediction of the most likely speaker of texts}
\usage{
stylest_odds(model, text, speaker, prior = NULL)
}
\arguments{
\item{model}{\code{stylest_model} object}

\item{text}{Text vector. May be a \code{corpus_frame} object}

\item{speaker}{Vector of speaker labels. Should be the same length as
\code{x}}

\item{prior}{Prior probability of speakers. Uses equal prior if \code{NULL}}
}
\value{
A S3 \code{stylest_odds} object containing: a
  \code{stylest_model} object; vector of mean log odds that each actual
  speaker (compared with other speakers in the corpus) spoke their
  corresponding texts in the corpus; vector of SEs of the log odds
}
\description{
Computes the mean log odds of the most likely speaker of each
text over pairs of the speaker of a text and every other speaker in the
\code{stylest_model}.
}
\examples{
data(novels_excerpts)
speaker_mod <- stylest_fit(novels_excerpts$text, novels_excerpts$author)
stylest_odds(speaker_mod, novels_excerpts$text, novels_excerpts$author)
  
}
