% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStatistics.r
\name{calculateStatistics}
\alias{calculateStatistics}
\title{Summary Statistics}
\usage{
calculateStatistics(
  data,
  target,
  quant = 0.95,
  group = NULL,
  count = NULL,
  decimals = -1,
  debug = FALSE
)
}
\arguments{
\item{data}{data.frame containing the data of interest.}

\item{target}{character column to calculate summary statistics for.}

\item{quant}{numeric quantile to calculate {0,1}, default 0.95.}

\item{group}{character vector of column(s) to group by, if any.}

\item{count}{character column to count unique values in, if any.}

\item{decimals}{numeric number of decimals. Negative does not round.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with summary statistics.
}
\description{
Calculate summary statistics for the selected target and scope.
}
\details{
Calculate summary statistics for the given target column ('X') across the
entire dataset or grouped by one or multiple columns, and counts the number
of unique values in the given count column ('Y'). Returns a data.frame
with the grouped columns, number of unique values 'Y.n', number of
observations 'X.n', the minimum value 'X.Min', the mean value 'X.Mean',
standard deviation 'X.Stdv', and the provided percentile 'X.Perc.##'.
For more details see \code{unique}, \code{min}, \code{mean}, \code{sd},
 \code{quantile}.
}
