% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{xtfrm2}
\alias{xtfrm2}
\alias{xtfrm2.default}
\alias{xtfrm2.character}
\alias{xtfrm}
\alias{xtfrm.default}
\alias{xtfrm.character}
\alias{sort.character}
\title{Sort Strings}
\usage{
xtfrm2(x, ...)

\method{xtfrm2}{default}(x, ...)

\method{xtfrm2}{character}(
  x,
  ...,
  locale = NULL,
  strength = 3L,
  alternate_shifted = FALSE,
  french = FALSE,
  uppercase_first = NA,
  case_level = FALSE,
  normalisation = FALSE,
  numeric = FALSE
)

xtfrm(x)

\method{xtfrm}{default}(x)

\method{xtfrm}{character}(x)

\method{sort}{character}(
  x,
  ...,
  decreasing = FALSE,
  na.last = NA,
  locale = NULL,
  strength = 3L,
  alternate_shifted = FALSE,
  french = FALSE,
  uppercase_first = NA,
  case_level = FALSE,
  normalisation = FALSE,
  numeric = FALSE
)
}
\arguments{
\item{x}{character vector whose elements are to be sorted}

\item{...}{further arguments passed to other methods}

\item{locale}{\code{NULL} or \code{""} for the default locale
(see \code{\link[stringi]{stri_locale_get}})
or a single string with a locale identifier,
see \code{\link[stringi]{stri_locale_list}}}

\item{strength}{see \code{\link[stringi]{stri_opts_collator}}}

\item{alternate_shifted}{see \code{\link[stringi]{stri_opts_collator}}}

\item{french}{see \code{\link[stringi]{stri_opts_collator}}}

\item{uppercase_first}{see \code{\link[stringi]{stri_opts_collator}}}

\item{case_level}{see \code{\link[stringi]{stri_opts_collator}}}

\item{normalisation}{see \code{\link[stringi]{stri_opts_collator}}}

\item{numeric}{see \code{\link[stringi]{stri_opts_collator}}}

\item{decreasing}{single logical value; if \code{FALSE}, the ordering
is nondecreasing (weakly increasing)}

\item{na.last}{single logical value; if \code{TRUE}, then missing values
are placed at the end; if \code{FALSE}, they are put at the beginning;
if \code{NA}, then they are removed from the output whatsoever.}
}
\value{
\code{sort.character} returns a character vector, with only
the \code{names} attribute preserved. Note that the output vector
may be shorter than the input one.

\code{xtfrm2.character} and \code{xtfrm.character} return an integer vector;
most attributes are preserved.
}
\description{
The \code{sort} method for objects of class \code{character}
(\code{sort.character}) uses the locale-sensitive Unicode collation
algorithm to arrange strings in a vector with regards to a
chosen lexicographic order.

\code{xtfrm2} and [DEPRECATED] \code{xtfrm} generate an integer vector
that sort in the same way as its input, and hence can be used
in conjunction with \code{\link[base]{order}} or \code{\link[base]{rank}}.
}
\details{
What 'xtfrm' stands for the current author does not know,
but would appreciate someone's enlightening him.
}
\section{Differences from Base R}{

Replacements for the default S3 methods \code{\link[base]{sort}}
and \code{\link[base]{xtfrm}} for character vectors
implemented with \code{\link[stringi]{stri_sort}}
and \code{\link[stringi]{stri_rank}}.

\itemize{
\item Collation in different locales is difficult and non-portable across
    platforms
    \bold{[fixed here -- using services provided by ICU]}
\item Overloading \code{xtfrm.character} has no effect in R, because S3
    method dispatch is done internally with hard-coded support for
    character arguments. Thus, we needed to replace the generic
    \code{xtfrm} with the one that calls \code{\link[base]{UseMethod}}
    \bold{[fixed here]}
\item \code{xtfrm} does not support customisation of the linear ordering
    relation it is based upon
    \bold{[fixed by introducing \code{...} argument to the new
    generic, \code{xtfrm2}]}
\item Neither \code{\link[base]{order}}, \code{\link[base]{rank}}, nor
    \code{\link[base]{sort.list}} is a generic, therefore
    they should have to be rewritten from scratch to allow the inclusion of
    our patches; interestingly, \code{order} even calls \code{xtfrm},
    but only for classed objects
    \bold{[not fixed here -- see Examples for a workaround]}
\item \code{xtfrm} for objects of type \code{character}
    does not preserve the names attribute (but does so for \code{numeric})
    \bold{[fixed here]}
\item \code{sort} seems to preserve only the names attribute
    which makes sense if \code{na.last} is \code{NA}, because the resulting
    vector might be shorter
    \bold{[not fixed here as it would break compatibility with other
    sorting methods]}
\item Note that \code{sort} by default removes missing values whatsoever,
    whereas \code{\link[base]{order}} has \code{na.last=TRUE}
    \bold{[not fixed here as it would break compatibility with other
    sorting methods]}
}
}

\examples{
x <- c("a1", "a100", "a101", "a1000", "a10", "a10", "a11", "a99", "a10", "a1")
base::sort.default(x)   # lexicographic sort
sort(x, numeric=TRUE)   # calls stringx:::sort.character
xtfrm2(x, numeric=TRUE)  # calls stringx:::xtfrm2.character

rank(xtfrm2(x, numeric=TRUE), ties.method="average")  # ranks with averaged ties
order(xtfrm2(x, numeric=TRUE))    # ordering permutation
x[order(xtfrm2(x, numeric=TRUE))] # equivalent to sort()

# order a data frame w.r.t. decreasing ids and increasing vals
d <- data.frame(vals=round(runif(length(x)), 1), ids=x)
d[order(-xtfrm2(d[["ids"]], numeric=TRUE), d[["vals"]]), ]


}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{strcoll}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
