% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compare.R
\name{stri_order}
\alias{stri_order}
\alias{stri_sort}
\title{Ordering Permutation and Sorting}
\usage{
stri_order(str, decreasing = FALSE, na_last = TRUE, ...,
  opts_collator = NULL)

stri_sort(str, decreasing = FALSE, na_last = NA, ...,
  opts_collator = NULL)
}
\arguments{
\item{str}{a character vector}

\item{decreasing}{a single logical value; should the sort order
be nondecreasing (\code{FALSE}, default)
or nonincreasing (\code{TRUE})?}

\item{na_last}{a single logical value; controls the treatment of \code{NA}s
in \code{str}. If \code{TRUE}, then missing values in \code{str} are put
at the end; if \code{FALSE}, they are put at the beginning;
if \code{NA}, then they are removed from the output.}

\item{...}{additional settings for \code{opts_collator}}

\item{opts_collator}{a named list with \pkg{ICU} Collator's options
as generated with \code{\link{stri_opts_collator}}, \code{NULL}
for default collation options}
}
\value{
For \code{stri_order}, an integer vector that gives the sort order
is returned.

For \code{stri_order}, you get a sorted version of \code{str},
i.e. a character vector.
}
\description{
\link{stri_order} determines a permutation which rearranges
strings into an ascending or descending order.
\link{stri_sort} sorts the vector according to a lexicographic order.
}
\details{
For more information on \pkg{ICU}'s Collator and how to tune it up
in \pkg{stringi}, refer to \code{\link{stri_opts_collator}}.

These functions use a stable sort algorithm (\pkg{STL}'s stable_sort),
which performs up to \eqn{N*log^2(N)} element comparisons,
where \eqn{N} is the length of \code{str}.

Interestingly, our benchmarks indicate that \code{stri_order}
is most often faster that \R's \code{order}.
}
\examples{
stri_sort(c("hladny", "chladny"), locale="pl_PL")

stri_sort(c("hladny", "chladny"), locale="sk_SK")
}
\references{
\emph{Collation} - ICU User Guide,
\url{http://userguide.icu-project.org/collation}
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_extract_all_words}},
  \code{\link{stri_extract_first_boundaries}},
  \code{\link{stri_extract_first_words}},
  \code{\link{stri_extract_last_boundaries}},
  \code{\link{stri_extract_last_words}};
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_locate_all_words}},
  \code{\link{stri_locate_first_boundaries}},
  \code{\link{stri_locate_first_words}},
  \code{\link{stri_locate_last_boundaries}},
  \code{\link{stri_locate_last_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}
}

