/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.multilabel;

import moa.classifiers.meta.WEKAClassifier;
import moa.core.InstancesHeader;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class MEKAClassifier
extends WEKAClassifier {
    private static final long serialVersionUID = 1L;
    protected int m_L = -1;

    public void setModelContext(InstancesHeader raw_header) {
        this.m_L = this.m_L < 0 ? raw_header.classIndex() + 1 : this.m_L;
        super.setModelContext(raw_header);
    }

    public void trainOnInstanceImpl(Instance inst) {
        if (this.m_L < 0) {
            this.m_L = inst.classIndex() + 1;
        }
        try {
            if (this.numberInstances < 1) {
                Instances D = inst.dataset();
                D.setClassIndex(this.m_L);
                this.instancesBuffer = new Instances(D);
                if (this.classifier instanceof UpdateableClassifier) {
                    this.instancesBuffer.setClassIndex(this.m_L);
                    this.classifier.buildClassifier(this.instancesBuffer);
                    this.isClassificationEnabled = true;
                } else {
                    System.err.println("Only suports UpdateableClassifiers for now.");
                    System.exit(1);
                }
            } else {
                ((UpdateableClassifier)((Object)this.classifier)).updateClassifier(inst);
            }
            ++this.numberInstances;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

