% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_FeaturesSelection.R
\name{DSF_FeatureSelection}
\alias{DSF_FeatureSelection}
\title{Select Features for a Data Stream}
\usage{
DSF_FeatureSelection(dsd = NULL, features)
}
\arguments{
\item{dsd}{A object of class \link{DSD} that will be scaled.}

\item{features}{a character vector with feature (column) names or the numeric index of
the selected features. All other features will be removed. Note special info columns
starting with \code{.} are not features.}
}
\value{
An object of class \code{DSF_FeatureSelection} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Select features from a data stream given a list of features.
}
\examples{
stream <- DSD_Gaussians(k = 3, d = 3)
get_points(stream, 3)

stream_2features <- DSF_FeatureSelection(stream, features = c("X1", "X3"))
stream_2features

get_points(stream_2features, n = 3)
}
\seealso{
Other DSF: 
\code{\link{DSF}()},
\code{\link{DSF_Convolve}()},
\code{\link{DSF_Downsample}()},
\code{\link{DSF_ExponentialMA}()},
\code{\link{DSF_Func}()},
\code{\link{DSF_Scale}()},
\code{\link{DSF_dplyr}()}
}
\author{
Michael Hahsler
}
\concept{DSF}
