/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.WekaPackageManager;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.CSVLoader;
import weka.core.converters.ConverterUtils;
import weka.core.converters.Loader;
import weka.core.converters.SerializedInstancesLoader;
import weka.datagenerators.DataGenerator;
import weka.experiment.InstanceQuery;
import weka.filters.Filter;
import weka.gui.AttributeSelectionPanel;
import weka.gui.AttributeSummaryPanel;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.ConverterFileChooser;
import weka.gui.GenericObjectEditor;
import weka.gui.InstancesSummaryPanel;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.SysErrLog;
import weka.gui.ViewerDialog;
import weka.gui.explorer.Explorer;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.explorer.PreprocessPanel;

public class PreprocessPanel
extends JPanel
implements Explorer.CapabilitiesFilterChangeListener,
Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 6764850273874813049L;
    protected InstancesSummaryPanel m_InstSummaryPanel = new InstancesSummaryPanel();
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected JButton m_OpenURLBut = new JButton("Open URL...");
    protected JButton m_OpenDBBut = new JButton("Open DB...");
    protected JButton m_GenerateBut = new JButton("Generate...");
    protected JButton m_UndoBut = new JButton("Undo");
    protected JButton m_EditBut = new JButton("Edit...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected AttributeSelectionPanel m_AttPanel = new AttributeSelectionPanel();
    protected JButton m_RemoveButton = new JButton("Remove");
    protected AttributeSummaryPanel m_AttSummaryPanel = new AttributeSummaryPanel();
    protected GenericObjectEditor m_FilterEditor = new GenericObjectEditor();
    protected PropertyPanel m_FilterPanel = new PropertyPanel((PropertyEditor)this.m_FilterEditor);
    protected JButton m_ApplyFilterBut = new JButton("Apply");
    protected ConverterFileChooser m_FileChooser = new ConverterFileChooser(new File(ExplorerDefaults.getInitialDirectory()));
    protected String m_LastURL = "http://";
    protected String m_SQLQ = new String("SELECT * FROM ?");
    protected Instances m_Instances;
    protected DataGenerator m_DataGenerator = null;
    protected AttributeVisualizationPanel m_AttVisualizePanel = new AttributeVisualizationPanel();
    protected File[] m_tempUndoFiles = new File[20];
    protected int m_tempUndoIndex = 0;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Thread m_IOThread;
    protected Logger m_Log = new SysErrLog();
    protected Explorer m_Explorer = null;

    public PreprocessPanel() {
        this.m_FilterEditor.setClassType(Filter.class);
        if (ExplorerDefaults.getFilter() != null) {
            this.m_FilterEditor.setValue(ExplorerDefaults.getFilter());
        }
        this.m_FilterEditor.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        this.m_OpenURLBut.setToolTipText("Open a set of instances from a URL");
        this.m_OpenDBBut.setToolTipText("Open a set of instances from a database");
        this.m_GenerateBut.setToolTipText("Generates artificial data");
        this.m_UndoBut.setToolTipText("Undo the last change to the dataset");
        this.m_EditBut.setToolTipText("Open the current dataset in a Viewer for editing");
        this.m_SaveBut.setToolTipText("Save the working relation to a file");
        this.m_ApplyFilterBut.setToolTipText("Apply the current filter to the data");
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_OpenURLBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_OpenDBBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_OpenFileBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_GenerateBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_UndoBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_EditBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_SaveBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_ApplyFilterBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_AttPanel.getSelectionModel().addListSelectionListener((ListSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_InstSummaryPanel.setBorder((Border)BorderFactory.createTitledBorder("Current relation"));
        JPanel attStuffHolderPanel = new JPanel();
        attStuffHolderPanel.setBorder(BorderFactory.createTitledBorder("Attributes"));
        attStuffHolderPanel.setLayout(new BorderLayout());
        attStuffHolderPanel.add((Component)this.m_AttPanel, "Center");
        this.m_RemoveButton.setEnabled(false);
        this.m_RemoveButton.setToolTipText("Remove selected attributes.");
        this.m_RemoveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new BorderLayout());
        p1.add((Component)this.m_RemoveButton, "Center");
        attStuffHolderPanel.add((Component)p1, "South");
        this.m_AttSummaryPanel.setBorder((Border)BorderFactory.createTitledBorder("Selected attribute"));
        this.m_UndoBut.setEnabled(false);
        this.m_EditBut.setEnabled(false);
        this.m_SaveBut.setEnabled(false);
        this.m_ApplyFilterBut.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(new GridLayout(1, 6, 5, 5));
        buttons.add(this.m_OpenFileBut);
        buttons.add(this.m_OpenURLBut);
        buttons.add(this.m_OpenDBBut);
        buttons.add(this.m_GenerateBut);
        buttons.add(this.m_UndoBut);
        buttons.add(this.m_EditBut);
        buttons.add(this.m_SaveBut);
        JPanel attInfo = new JPanel();
        attInfo.setLayout(new BorderLayout());
        attInfo.add((Component)attStuffHolderPanel, "Center");
        JPanel filter = new JPanel();
        filter.setBorder(BorderFactory.createTitledBorder("Filter"));
        filter.setLayout(new BorderLayout());
        filter.add((Component)this.m_FilterPanel, "Center");
        filter.add((Component)this.m_ApplyFilterBut, "East");
        JPanel attVis = new JPanel();
        attVis.setLayout(new GridLayout(2, 1));
        attVis.add((Component)this.m_AttSummaryPanel);
        JComboBox colorBox = this.m_AttVisualizePanel.getColorBox();
        colorBox.setToolTipText("The chosen attribute will also be used as the class attribute when a filter is applied.");
        colorBox.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
        JButton visAllBut = new JButton("Visualize All");
        visAllBut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel histoHolder = new JPanel();
        histoHolder.setLayout(new BorderLayout());
        histoHolder.add((Component)this.m_AttVisualizePanel, "Center");
        JPanel histoControls = new JPanel();
        histoControls.setLayout(new BorderLayout());
        histoControls.add((Component)colorBox, "Center");
        histoControls.add((Component)visAllBut, "East");
        histoHolder.add((Component)histoControls, "North");
        attVis.add(histoHolder);
        JPanel lhs = new JPanel();
        lhs.setLayout(new BorderLayout());
        lhs.add((Component)this.m_InstSummaryPanel, "North");
        lhs.add((Component)attInfo, "Center");
        JPanel rhs = new JPanel();
        rhs.setLayout(new BorderLayout());
        rhs.add((Component)attVis, "Center");
        JPanel relation = new JPanel();
        relation.setLayout(new GridLayout(1, 2));
        relation.add(lhs);
        relation.add(rhs);
        JPanel middle = new JPanel();
        middle.setLayout(new BorderLayout());
        middle.add((Component)filter, "North");
        middle.add((Component)relation, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)buttons, "North");
        this.add((Component)middle, "Center");
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        try {
            14 r = new /* Unavailable Anonymous Inner Class!! */;
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait((Runnable)r);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Problem setting base instances:\n" + ex, "Instances", 0);
        }
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    protected void applyFilter(Filter filter) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't apply filter at this time,\ncurrently busy with other IO", "Apply Filter", 2);
        }
    }

    public void saveWorkingInstancesToFileQ() {
        if (this.m_IOThread == null) {
            this.m_FileChooser.setCapabilitiesFilter(this.m_FilterEditor.getCapabilitiesFilter());
            this.m_FileChooser.setAcceptAllFileFilterUsed(false);
            int returnVal = this.m_FileChooser.showSaveDialog((Component)this);
            if (returnVal == 0) {
                Instances inst = new Instances(this.m_Instances);
                inst.setClassIndex(this.m_AttVisualizePanel.getColoringIndex());
                this.saveInstancesToFile(this.m_FileChooser.getSaver(), inst);
            }
            FileFilter temp = this.m_FileChooser.getFileFilter();
            this.m_FileChooser.setAcceptAllFileFilterUsed(true);
            this.m_FileChooser.setFileFilter(temp);
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Save Instances", 2);
        }
    }

    public void saveInstancesToFile(AbstractFileSaver saver, Instances inst) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't save at this time,\ncurrently busy with other IO", "Saving instances", 2);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int returnVal = this.m_FileChooser.showOpenDialog((Component)this);
            if (returnVal == 0) {
                try {
                    this.addUndoPoint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_FileChooser.getLoader() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot determine file loader automatically, please choose one.", "Load Instances", 0);
                    this.converterQuery(this.m_FileChooser.getSelectedFile());
                } else {
                    this.setInstancesFromFile(this.m_FileChooser.getLoader());
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDBQ(String url, String user, String pw, String query) {
        this.setInstancesFromDBQ(url, user, pw, query, false);
    }

    public void setInstancesFromDBQ(String url, String user, String pw, String query, boolean sparse) {
        if (this.m_IOThread == null) {
            try {
                InstanceQuery InstQ = new InstanceQuery();
                InstQ.setDatabaseURL(url);
                InstQ.setUsername(user);
                InstQ.setPassword(pw);
                InstQ.setQuery(query);
                InstQ.setSparseData(sparse);
                if (InstQ.isConnected()) {
                    InstQ.disconnectFromDatabase();
                }
                InstQ.connectToDatabase();
                try {
                    this.addUndoPoint();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                this.setInstancesFromDB(InstQ);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Problem connecting to database:\n" + ex.getMessage(), "Load Instances", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURLQ() {
        block6: {
            if (this.m_IOThread == null) {
                try {
                    String urlName = (String)JOptionPane.showInputDialog(this, "Enter the source URL", "Load Instances", 3, null, null, this.m_LastURL);
                    if (urlName == null) break block6;
                    this.m_LastURL = urlName;
                    URL url = new URL(urlName);
                    try {
                        this.addUndoPoint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setInstancesFromURL(url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Problem with URL:\n" + ex.getMessage(), "Load Instances", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
            }
        }
    }

    public void generateInstances() {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't generate data at this time,\ncurrently busy with other IO", "Generate Data", 2);
        }
    }

    protected void showGeneratedInstances(String data) {
        JDialog dialog = new JDialog();
        JButton saveButton = new JButton("Save");
        JButton closeButton = new JButton("Close");
        JTextArea textData = new JTextArea(data);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        textData.setEditable(false);
        textData.setFont(new Font("Monospaced", 0, textData.getFont().getSize()));
        saveButton.setMnemonic('S');
        saveButton.setToolTipText("Saves the output to a file");
        saveButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        closeButton.setMnemonic('C');
        closeButton.setToolTipText("Closes the dialog");
        closeButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        panel.add(saveButton);
        panel.add(closeButton);
        dialog.setTitle("Generated Instances (incl. comments)");
        dialog.getContentPane().add((Component)new JScrollPane(textData), "Center");
        dialog.getContentPane().add((Component)panel, "South");
        dialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (double)dialog.getWidth() > screen.getWidth() * 0.8 ? (int)(screen.getWidth() * 0.8) : dialog.getWidth();
        int height = (double)dialog.getHeight() > screen.getHeight() * 0.8 ? (int)(screen.getHeight() * 0.8) : dialog.getHeight();
        dialog.setSize(width, height);
        dialog.setVisible(true);
    }

    private void converterQuery(File f) {
        GenericObjectEditor convEd = new GenericObjectEditor(true);
        try {
            convEd.setClassType(Loader.class);
            convEd.setValue(new CSVLoader());
            ((GenericObjectEditor.GOEPanel)convEd.getCustomEditor()).addOkListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            // empty catch block
        }
        PropertyDialog pd = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)convEd, 100, 100) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)convEd, 100, 100);
        pd.setVisible(true);
    }

    private void tryConverter(Loader cnv, File f) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        }
    }

    public void setInstancesFromFile(AbstractFileLoader loader) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromDB(InstanceQuery iq) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURL(URL u) {
        if (this.m_IOThread == null) {
            this.m_IOThread = new /* Unavailable Anonymous Inner Class!! */;
            this.m_IOThread.setPriority(1);
            this.m_IOThread.start();
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void addUndoPoint() throws Exception {
        if (this.m_Instances != null) {
            File tempFile = File.createTempFile("weka", SerializedInstancesLoader.FILE_EXTENSION);
            tempFile.deleteOnExit();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            oos.writeObject(this.m_Instances);
            oos.flush();
            oos.close();
            if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
                this.m_tempUndoFiles[this.m_tempUndoIndex].delete();
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = tempFile;
            if (++this.m_tempUndoIndex >= this.m_tempUndoFiles.length) {
                this.m_tempUndoIndex = 0;
            }
            this.m_UndoBut.setEnabled(true);
        }
    }

    public void undo() {
        int temp;
        if (--this.m_tempUndoIndex < 0) {
            this.m_tempUndoIndex = this.m_tempUndoFiles.length - 1;
        }
        if (this.m_tempUndoFiles[this.m_tempUndoIndex] != null) {
            AbstractFileLoader loader = ConverterUtils.getLoaderForFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
            try {
                loader.setFile(this.m_tempUndoFiles[this.m_tempUndoIndex]);
                this.setInstancesFromFile(loader);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_Log.logMessage(e.toString());
                JOptionPane.showMessageDialog(this, "Cannot perform undo operation!\n" + e.toString(), "Undo", 0);
            }
            this.m_tempUndoFiles[this.m_tempUndoIndex] = null;
        }
        if ((temp = this.m_tempUndoIndex - 1) < 0) {
            temp = this.m_tempUndoFiles.length - 1;
        }
        this.m_UndoBut.setEnabled(this.m_tempUndoFiles[temp] != null);
    }

    public void edit() {
        int classIndex = this.m_AttVisualizePanel.getColoringIndex();
        Instances copy = new Instances(this.m_Instances);
        copy.setClassIndex(classIndex);
        ViewerDialog dialog = new ViewerDialog(null);
        int result = dialog.showDialog(copy);
        if (result == 0) {
            try {
                this.addUndoPoint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Instances newInstances = dialog.getInstances();
            if (this.m_Instances.classIndex() < 0) {
                newInstances.setClassIndex(-1);
            }
            this.setInstances(newInstances);
        }
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    protected void updateCapabilitiesFilter(Capabilities filter) {
        Capabilities filterClass;
        if (filter == null) {
            this.m_FilterEditor.setCapabilitiesFilter(new Capabilities(null));
            return;
        }
        Instances tempInst = !ExplorerDefaults.getInitGenericObjectEditorFilter() ? new Instances(this.m_Instances, 0) : new Instances(this.m_Instances);
        tempInst.setClassIndex(this.m_AttVisualizePanel.getColorBox().getSelectedIndex() - 1);
        try {
            filterClass = Capabilities.forInstances(tempInst);
        }
        catch (Exception e) {
            filterClass = new Capabilities(null);
        }
        this.m_FilterEditor.setCapabilitiesFilter(filterClass);
        this.m_ApplyFilterBut.setEnabled(true);
        Capabilities currentCapabilitiesFilter = this.m_FilterEditor.getCapabilitiesFilter();
        Filter currentFilter = (Filter)this.m_FilterEditor.getValue();
        Capabilities currentFilterCapabilities = null;
        if (currentFilter != null && currentCapabilitiesFilter != null && currentFilter instanceof CapabilitiesHandler && !(currentFilterCapabilities = currentFilter.getCapabilities()).supportsMaybe(currentCapabilitiesFilter) && !currentFilterCapabilities.supports(currentCapabilitiesFilter)) {
            this.m_ApplyFilterBut.setEnabled(false);
        }
    }

    public void capabilitiesFilterChanged(Explorer.CapabilitiesFilterChangeEvent e) {
        if (e.getFilter() == null) {
            this.updateCapabilitiesFilter(null);
        } else {
            this.updateCapabilitiesFilter((Capabilities)e.getFilter().clone());
        }
    }

    public String getTabTitle() {
        return "Preprocess";
    }

    public String getTabTitleToolTip() {
        return "Open/Edit/Save instances";
    }

    public static void main(String[] args) {
        try {
            JFrame jf = new JFrame("Weka Explorer: Preprocess");
            jf.getContentPane().setLayout(new BorderLayout());
            PreprocessPanel sp = new PreprocessPanel();
            jf.getContentPane().add((Component)sp, "Center");
            LogPanel lp = new LogPanel();
            sp.setLog((Logger)lp);
            jf.getContentPane().add((Component)lp, "South");
            jf.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static /* synthetic */ void access$000(PreprocessPanel x0, Loader x1, File x2) {
        x0.tryConverter(x1, x2);
    }

    static /* synthetic */ void access$100(PreprocessPanel x0, File x1) {
        x0.converterQuery(x1);
    }

    static {
        WekaPackageManager.loadPackages(false);
        GenericObjectEditor.registerEditors();
    }
}

