/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import weka.core.Instance;

public class BasicRegressionPerformanceEvaluator
extends AbstractMOAObject
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double squareError;
    protected double averageError;

    public void reset() {
        this.weightObserved = 0.0;
        this.squareError = 0.0;
        this.averageError = 0.0;
    }

    public void addResult(Instance inst, double[] prediction) {
        if (inst.weight() > 0.0) {
            this.weightObserved += inst.weight();
            if (prediction.length > 0 && this.weightObserved != inst.weight()) {
                this.squareError += (inst.classValue() - prediction[0]) * (inst.classValue() - prediction[0]);
                this.averageError += Math.abs(inst.classValue() - prediction[0]);
            }
        }
    }

    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("mean absolute error", this.getMeanError()), new Measurement("root mean squared error", this.getSquareError())};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getMeanError() {
        return this.weightObserved > 0.0 ? this.averageError / this.weightObserved : 0.0;
    }

    public double getSquareError() {
        return Math.sqrt(this.weightObserved > 0.0 ? this.squareError / this.weightObserved : 0.0);
    }

    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }
}

