% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R
\name{plot.manual_strata}
\alias{plot.manual_strata}
\title{Plot method for \code{manual_strata} object}
\usage{
\method{plot}{manual_strata}(x, type = "SR", label = FALSE, stratum = "all", propensity, ...)
}
\arguments{
\item{x}{a \code{manual_strata} object returned by
\code{\link{manual_stratify}}}

\item{type}{string giving the plot type (default = \code{"SR"}).  Other
option is \code{"hist"}}

\item{label}{ignored unless \code{type = "SR"}. If \code{TRUE}, a clickable
plot is produced. The user may click on any number of strata and press
finish to have those strata labeled.  Note: uses \code{\link{identify}},
which may not be supported on some devices}

\item{stratum}{ignored unless \code{type = "hist"}. A number specifying which
stratum to plot.}

\item{propensity}{ignored unless \code{type = "hist"}. Specifies propensity
score information for plots where this is required. Accepts either a vector
of propensity scores, a \code{glm} model for propensity scores, or a
formula for fitting a propensity score model.}

\item{...}{other arguments}
}
\description{
Generates diagnostic plots for the product of a stratification by
\code{\link{manual_stratify}}.  There are two plot types: \enumerate{ \item
\code{"SR"} (default) - produces a scatter plot of strata by size and
treat:control ratio \item \code{"hist"} - produces a histogram of propensity
scores within a stratum.} Note that residual plots and AC plots are not
supported for \code{manual_strata} objects because no prognostic model is
fit.
}
\examples{
dat <- make_sample_data()
m.strat <- manual_stratify(dat, treat ~ C1)
plot(m.strat) # makes size-ratio scatter plot
plot(m.strat, type = "hist", propensity = treat ~ X1, stratum = 1)
}
