% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify.R
\name{stratify}
\alias{stratify}
\title{Stratify gtypes}
\usage{
stratify(g, scheme = NULL, drop = TRUE)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{scheme}{either the column name of a stratification scheme stored 
in the data.frame of the \code{schemes} slot of \code{g}, or a vector or 
factor identifying which stratum each sample belongs to. If \code{NULL},
all individuals are assigned to a single stratum named \code{"Default"}.}

\item{drop}{remove samples not assigned to a stratum? (those assigned \code{NA} 
in stratification scheme)}
}
\value{
A new \linkS4class{gtypes} object with an updated \code{strata} slot.
}
\description{
Choose a new stratification scheme from the \code{schemes}
  slot in a \linkS4class{gtypes} object.
}
\note{
If \code{scheme} is a vector or factor and has names, then the 
  they will be used to match with \code{\link{getIndNames}} of \code{g}. 
  Otherwise \code{scheme} should be the same length as the number of 
  samples in \code{g} or values in \code{scheme} will be recycled as 
  necessary.
}
\examples{
data(msats.g)
msats.g

broad.msats <- stratify(msats.g, "broad")
broad.msats

}
\seealso{
\link{getSchemes}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
