% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fscWrite.R
\name{fscWrite}
\alias{fscWrite}
\title{Write fastsimcoal2 input files}
\usage{
fscWrite(
  demes,
  genetics,
  migration = NULL,
  events = NULL,
  est = NULL,
  def = NULL,
  label = "strataG.fsc",
  use.wd = FALSE
)
}
\arguments{
\item{demes}{matrix of deme sampling information created by the 
\code{\link{fscSettingsDemes}} function.}

\item{genetics}{data.frame specifying loci to simulate created by the 
\code{\link{fscSettingsGenetics}} function.}

\item{migration}{a list of matrices giving the migration rates 
between pairs of demes created by the \code{\link{fscSettingsMigration}} 
function.}

\item{events}{matrix of historical events created by the 
\code{\link{fscSettingsEvents}} function.}

\item{est}{list of parameter estimation definitions and rules generated by 
the \code{\link{fscSettingsEst}} function.}

\item{def}{matrix of parameter values to substitute into the model generated 
by the \code{\link{fscSettingsDef}} function.}

\item{label}{character string used to label output files for the simulation.}

\item{use.wd}{use current working directory for input and output? If 
\code{FALSE} then a temporary directory in the session temporary directory. 
Note that this directory is deleted when the R session closed. See 
\code{\link{tempdir}} for more information.}
}
\value{
Writes input files for \code{fastsimcoal2} and returns a list of
  input parameters, input file, and input filenames. This list is the primary
  input to \code{\link{fscRun}}.
}
\description{
Write files necessary to run a \code{fastsimcoal2} simulation.
}
\note{


\code{fastsimcoal2} is not included with `strataG` and must be
  downloaded separately. Additionally, it must be installed such that it can
  be run from the command line in the current working directory. 
  The function \code{fscTutorial()} will open a detailed tutorial on the 
  interface in your web browser.
}
\examples{
\dontrun{
#' # three demes with optional names
demes <- fscSettingsDemes(
  Large = fscDeme(10000, 10), 
  Small = fscDeme(2500, 10),
  Medium = fscDeme(5000, 3, 1500)
)

# four historic events
events <- fscSettingsEvents(
  fscEvent(event.time = 2000, source = 1, sink = 2, prop.migrants = 0.05),
  fscEvent(2980, 1, 1, 0, 0.04),
  fscEvent(3000, 1, 0),
  fscEvent(15000, 0, 2, new.size = 3)
 )
 
# four genetic blocks of different types on three chromosomes.  
genetics <- fscSettingsGenetics(
  fscBlock_snp(10, 1e-6, chromosome = 1),
  fscBlock_dna(10, 1e-5, chromosome = 1),
  fscBlock_microsat(3, 1e-4, chromosome = 2),
  fscBlock_standard(5, 1e-3, chromosome = 3)
)

params <- fscWrite(demes = demes, events = events, genetics = genetics)
}

}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time 
  coalescent simulator of genomic diversity under arbitrarily complex 
  evolutionary scenarios Bioinformatics 27: 1332-1334.\cr
  Excoffier, L., Dupanloup, I., Huerta-Sánchez, E., Sousa, V.C., 
  and M. Foll (2013) Robust demographic inference from genomic and SNP data. 
  PLOS Genetics, 9(10):e1003905. \cr
  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}
\seealso{
\code{\link{fsc.input}}, \code{\link{fscRun}}, \code{\link{fscRead}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
