% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase.R
\name{phase}
\alias{phase}
\alias{phaseReadSample}
\alias{phaseReadPair}
\alias{phaseWrite}
\alias{phasePosterior}
\alias{phaseFilter}
\title{PHASE}
\usage{
phase(g, loci, positions = NULL, type = NULL, num.iter = 1e+05,
  thinning = 100, burnin = 1e+05, model = "new", ran.seed = NULL,
  final.run.factor = NULL, save.posterior = FALSE, in.file = "phase_in",
  out.file = "phase_out", delete.files = TRUE)

phaseReadSample(out.file, type)

phaseReadPair(out.file)

phaseWrite(g, loci, positions = NULL, type = rep("S", length(loci)),
  in.file = "phase_in")

phasePosterior(ph.res, keep.missing = TRUE)

phaseFilter(ph.res, thresh = 0.5, keep.missing = TRUE)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{loci}{vector or data.frame of loci in 'g' that are to be phased. If a 
data.frame, it should have columns named \code{locus} (name of locus in 'g'),  
\code{group} (number identifying loci in same linkage group), and
\code{position} (integer identifying location of each locus in a linkage group).}

\item{positions}{position along chromosome of each locus.}

\item{type}{type of each locus.}

\item{num.iter}{number of PHASE MCMC iterations.}

\item{thinning}{number of PHASE MCMC iterations to thin by.}

\item{burnin}{number of PHASE MCMC iterations for burnin.}

\item{model}{PHASE model type.}

\item{ran.seed}{PHASE random number seed.}

\item{final.run.factor}{optional.}

\item{save.posterior}{logical. Save posterior sample in output list?}

\item{in.file}{name to use for PHASE input file.}

\item{out.file}{name to use for PHASE output files.}

\item{delete.files}{logical. Delete PHASE input and output files when done?}

\item{ph.res}{result from \code{phase.run}.}

\item{keep.missing}{logical. T = keep missing data from original data set. F = Use estimated genotypes from PHASE.}

\item{thresh}{minimum probability for a genotype to be selected (0.5 - 1).}
}
\value{
\describe{
 \item{phase}{a list containing:
   \tabular{ll}{
     \code{locus.name} \tab new locus name, which is a combination of loci in group.\cr
     \code{gtype.probs} \tab a data.frame listing the estimated genotype for every sample along with probability.\cr
     \code{orig.gtypes} \tab the original gtypes object for the composite loci.\cr
     \code{posterior} \tab a list of \code{num.iter} data.frames representing posterior sample of genotypes for each sample.\cr
   }}
 \item{phaseWrite}{a list with the input filename and the \linkS4class{gtypes} object used.}
 \item{phaseReadPair}{a data.frame of genotype probabilities.}
 \item{phaseReadSample}{a list of data.frames representing the posterior sample of genotypes for one set of loci for each sample.}
 \item{phaseFilter}{a matrix of genotypes for each sample.}
 \item{phasePosterior}{a list of data.frames representing the posterior sample of all genotypes for each sample.}
}
}
\description{
Run PHASE to estimate the phase of loci in diploid data.
}
\details{
\tabular{ll}{
  \code{phase} \tab runs PHASE assuming that the executable is installed properly and available on the command line.\cr
  \code{phaseWrite} \tab writes a PHASE formatted file.\cr
  \code{phaseReadPair} \tab reads the '_pair' output file.\cr
  \code{phaseReadSample} \tab reads the '_sample' output file.\cr
  \code{phaseFilter} \tab filters the result from \code{phase.run} to extract one genotype for each sample.\cr
  \code{phasePosterior} \tab create a data.frame all genotypes for each posterior sample.\cr
}
}
\note{
PHASE is not included with \code{strataG} and must be downloaded 
  separately. Additionally, it must be installed such that it can be run from 
  the command line in the current working directory. See the vignette 
  for \code{external.programs} for installation instructions.
}
\examples{
\dontrun{
data(bowhead.snps)
data(bowhead.snp.position)
snps <- df2gtypes(bowhead.snps, ploidy = 2, description = "Bowhead SNPS")
summary(snps)

# Run PHASE on all data
phase.results <- phase(snps, bowhead.snp.position, num.iter = 100, 
  save.posterior = FALSE)

# Filter phase results
filtered.results <- phaseFilter(phase.results, thresh = 0.5)

# Convert phased genotypes to gtypes
ids <- rownames(filtered.results)
strata <- bowhead.snps$Stock[match(ids, bowhead.snps$LABID)]
filtered.df <- cbind(id = ids, strata = strata, filtered.results)
phased.snps <- df2gtypes(filtered.df, ploidy = 2, description = "Bowhead phased SNPs")
summary(phased.snps)
}

}
\references{
Stephens, M., and Donnelly, P. (2003). A comparison of Bayesian methods for haplotype reconstruction from 
  population genotype data. American Journal of Human Genetics 73:1162-1169.
  Available at: \url{http://stephenslab.uchicago.edu/software.html#phase}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
