% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedDifferences.R
\name{fixedDifferences}
\alias{fixedDifferences}
\title{Fixed Differences}
\usage{
fixedDifferences(g, count.indels = TRUE, consec.indels.as.one = TRUE,
  bases = c("a", "c", "g", "t", "-"))
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{count.indels}{logical. Count indels when evaluating sites for fixed 
differences?}

\item{consec.indels.as.one}{logical. If \code{count.indels} is TRUE, count 
consecutive indels as a a single indel?}

\item{bases}{a character vector of valid bases to consider.}
}
\value{
a list with components:
\tabular{ll}{
  \code{sites} \tab list of sites with fixed differences for each pair of 
    strata \cr
  \code{num.fixed} \tab data.frame of number of sites fixed between each 
    pair of strata \cr
}
}
\description{
Summarize fixed base pair differences between strata.
}
\author{
Eric Archer <eric.archer@noaa.gov>
}
\seealso{
\code{\link{fixedSites}}, \code{\link{variableSites}}
}

