% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence2gtypes.R
\name{sequence2gtypes}
\alias{sequence2gtypes}
\title{Convert Sequences To \code{gtypes}}
\usage{
sequence2gtypes(x, strata = NULL, seq.names = NULL, schemes = NULL,
  description = NULL, other = NULL)
}
\arguments{
\item{x}{DNA sequences as a character matrix, a \code{\link{DNAbin}} object, 
or \linkS4class{multidna} object.}

\item{strata}{a vector or factor giving stratification for each sequence. If 
not provided all individuals are assigned to the same stratum (Default).}

\item{seq.names}{names for each set of sequences. If not provided default names 
are generated.}

\item{schemes}{an optional data.frame of stratification schemes.}

\item{description}{an optional label for the object.}

\item{other}{a slot to carry other related information - unused in package
analyses.}
}
\value{
a \linkS4class{gtypes} object.
}
\description{
Create a \linkS4class{gtypes} object from sequence data.
}
\examples{
#--- create a haploid sequence (mtDNA) gtypes object
data(dolph.strata)
data(dolph.seqs)
strata <- dolph.strata$fine
names(strata) <- dolph.strata$ids
dloop.fine <- sequence2gtypes(dolph.seqs, strata, seq.names = "dLoop", 
description = "dLoop: fine-scale stratification")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

