% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stat.d.jost}
\alias{stat.d.jost}
\title{Jost's D Estimate of Population Divergence}
\usage{
stat.d.jost(g)
}
\arguments{
\item{g}{a \code{gtypes} object.}
}
\description{
Jost's D Estimate of Population Divergence
}
\details{
Calculate Dest as presented in Jost 2008, Eqn 13.
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5, description = "msats")

stat.d.jost(msats)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

