% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect.resampled_df}
\alias{collect.resampled_df}
\title{Force virtual groups to become explicit rows}
\usage{
\method{collect}{resampled_df}(x, ..., id = NULL, original_id = NULL)
}
\arguments{
\item{x}{A \code{resampled_df}.}

\item{...}{Not used.}

\item{id}{Optional. A single character that specifies a name for a column
containing a sequence from \code{1:n} for each bootstrap group.}

\item{original_id}{Optional. A single character that specifies a name for
a column containing the original position of the bootstrapped row.}
}
\description{
When \code{collect()} is used on a \code{resampled_df}, the virtual bootstrap groups
are made explicit.
}
\examples{
library(dplyr)

# virtual groups become real rows
collect(bootstrapify(iris, 5))

# add on the id column for an identifier per bootstrap
collect(bootstrapify(iris, 5), id = ".id")

# add on the original_id column to know which row this bootstrapped row
# originally came from
collect(bootstrapify(iris, 5), original_id = ".original_id")

}
