% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lucky_odds.R
\name{lucky_odds}
\alias{lucky_odds}
\title{Quickly apply stanger full process flow to flag candidates anomalies applying one weird method}
\usage{
lucky_odds(data, n.anom = 5, ..., analysis.drop = NULL,
  analysis.keep = NULL, weird = "knn", stack = "avg",
  stack.method = "norm")
}
\arguments{
\item{data}{Source data (data.frame or data.table).}

\item{n.anom}{Number of anomaly candidate records to flags.}

\item{\dots}{Additional parameters to be passed to weird method (\code{analysis.method}).}

\item{analysis.drop}{Character - set of variables to be removed from analysis (metrics computations by weird).}

\item{analysis.keep}{Character - set of variables to be kept for analyis  (metrics computations by weird).}

\item{weird}{weird method to use for metric computation}

\item{stack}{Stacking metric passed to \code{\link{get_anomalies}}.}

\item{stack.method}{Stacking selection method passed to  \code{\link{get_anomalies}}.}
}
\description{
\code{lucky_odds} is basically a wrapper around the process: \code{\link{add_id}} --> \code{\link{crazyfy}}
--> \code{\link{strange}} (weird method with set of parameters) --> \code{\link{singularize}}
 (default parameters: all methods)
--> \code{\link{get_anomalies}} (flag top \emph{n.anom} anomalies) --> \code{\link{fortify}} to enrich source data.
By calling \code{lucky_odds}, analyst gets back source data with an additional column flagging some records.
Though obviously simplifying the analysis process, not all options are available and intermediate objects
are not available for further analysis.
}
\section{Selecting variables}{

If your source data contains variables you don't want to use in metrics computations - weird method: knnw, autoencode...,
then you have to first select analysis variables. You can thos this use either \code{analysis.keep} OR \code{analysis.drop}.
Those two parameters are mutually exclusive.
library(stranger)
data(iris)
anomalies <- lucky_odds(iris[,1:4])
table(anomalies$flag_anomaly)
}

