% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.CI.R
\name{HP.CI}
\alias{HP.CI}
\title{Helligman-Pollard confidence intervals with 9 parameters}
\usage{
HP.CI(HPout, age, CI = 95, M = "total")
}
\arguments{
\item{HPout}{A model object created with \link{HP.mod} with the Heligman-Pollard estimated params}

\item{age}{A vector of the ages at which the probabilities of death will be calculated.}

\item{CI}{Defines the width of the credible interval (Defaults to 95 percent).
A summary table is printed with the median estimate and lower and upper confidence bounds.
Setting CI = 95 prints a table with the first column representing the 2.5th
percentile for each parameter distribution, the second column represents the median
value for each parameter distribution and the third column represents the
97.5th percentile for each parameter distribution.}

\item{M}{The type of probabilities to be calculated. Can be both "natural" mortality,
"total" mortality and mortality due to an external risk.}
}
\value{
Return a dataframe with number of rows equal to the number of age classes and four columns:
\item{age}{Vetor with age classes.}
\item{Med}{Median prediction of probabilities of death at age.}
\item{Mlo}{Lower limit of prediction of probabilities of death at age with CI = (100 - CI)/2.}
\item{Mhi}{Higher limit of prediction of probabilities of death at age with CI = 1- (100 - CI)/2.}
}
\description{
Predicts Helligman-Pollard model with the estimated parameters both "natural" mortality,
"total" mortality and mortality due to an external risk with confidence intervals.
}
\details{
The type of mortality to be calculated must be defined. By default the total probability of death
is calculated but only natural mortality or due to an external risk can be calculad if previously defined.
}
\references{
Heligman, L. and Pollard, J.H. (1980). The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.
}
\seealso{
\code{\link{hp.nqx}} \code{\link{mod}} \code{\link{mod.nat}} \code{\link{mod.risk}}
}
\keyword{Heligman-Pollard}
\keyword{confidence-intervals}
