% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{v2lv}
\alias{v2lv}
\title{(Atomic) Vector to List of (Atomic) Vectors}
\usage{
v2lv(v, use.names = TRUE, n.break = 1L, warn.break = TRUE, check = TRUE)
}
\arguments{
\item{v}{(atomic) vector.}

\item{use.names}{logical vector of length 1 specifying whether the names from
\code{v} should be retained in the return object.}

\item{n.break}{integer vector of length 1 specifying how \code{v} should be broken
up. Every {n.break} elements while seq_along \code{v}, a new element of the list
is created and subsequent elements of \code{v} are stored there. If \code{n.break}
is not a multiple of \code{length(v)}, then NAs are appended to the end of \code{v}
to ensure that each list element has (atomic) vectors of the same length. Note, the
default is 1L resulting in a list vector.}

\item{warn.break}{logical vector of length one specifying whether a warning
should be printed if \code{length(v) / n.break} is not a whole number, which
would then result in NAs being appended to the end of the vector before converting
to a list.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{v} is an atomic vector.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
list of (atomic) vectors that are the elements of \code{v} broken up
according to \code{n.break}. The list only has names if \code{v} has names and
\code{n.break} = 1L.
}
\description{
\code{v2lv} converts a (atomic) vector to a list of atomic vectors. The default is
conversion to a list vector where each element of the list has only one element.
The \code{n.break} argument allows for the input vector to be broken up into
larger sections with each section being a list element in the return object.
}
\details{
Future versions of this function plan to allow for use similar to the \code{utils::relist}
function to allow reconstruction after flattening a matrix-like object to a single vector.
}
\examples{
vec <- setNames(object = mtcars[[1]], nm = row.names(mtcars))
v2lv(vec)
v2lv(vec, use.names = FALSE)
vec <- unlist(mtcars)
v2lv(vec, n.break = 32) # n.break > 1L and multiple of length(v)
v2lv(vec, n.break = 30) # n.break > 1L and NOT multiple of length(v)
}
