% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{a2la}
\alias{a2la}
\title{(3D+) Array to List of (3D+) Arrays}
\usage{
a2la(a, along = ndim(a), check = TRUE)
}
\arguments{
\item{a}{(3D+) array}

\item{along}{integerish vector of length 1 specifying the dimension to split
the array along. Default is the last dimension of \code{a}.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{a} is a 3D+ array.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
list of arrays where each array is one dimension less than \code{a}
and the names of the list are \code{dimnames(a)[[along]]}.
}
\description{
\code{a2la} converts an (3D+) array to a list of (3D+) arrays. This function
is a simple wrapper for \code{asplit(x = a, MARGIN = along)}.
}
\examples{
# without dimnames
a <- abind::abind(HairEyeColor*1, HairEyeColor*2, HairEyeColor*3, along = 4L)
a2la(a)
# with dimnames
a <- abind::abind("one" = HairEyeColor*1, "two" = HairEyeColor*2,
   "three" = HairEyeColor*3, along = 4L)
a2la(a)
a2la(a, along = 1) # along = 1
}
