% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_areas.R
\name{compare_areas}
\alias{compare_areas}
\title{Compare two areas}
\usage{
compare_areas(area1, area2,
display_output = FALSE)
}
\arguments{
\item{area1}{(as \code{spatialPolygons},
\code{spatialPolygonDataFrames}, or
\verb{simple features}). the polygon object of the
first area.}

\item{area2}{(as \code{spatialPolygons},
\code{spatialPolygonDataFrames}, or
\verb{simple features}). the polygon object of the
second area.}

\item{display_output}{(logical) Whether to print output
in the console.
Default: \code{FALSE}}
}
\value{
Returns a plot and a text (string) comparing
the sizes of two areas.
}
\description{
To compare the sizes of two
areas (boundary shapefiles).
}
\details{
Compares the sizes of two areas (polygon shapefiles).
The two shapefiles can be in any \code{crs},
and any spatial object formats. If enabled, the output (a value)
comparing the area of the two polygons is printed. This value can
be used to scale some specific spatial parameters, including
\code{n_origin}, \code{s_threshold}, and \code{step_length}.
}
\examples{
#load 'area1' object - boundary of Camden, UK
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
camden_boundary = camden$boundary

#load 'area2' - boundary of Birmingham, UK
load(file = system.file("extdata", "birmingham_boundary.rda",
package="stppSim"))

#run
compare_areas(area1 = camden_boundary,
area2 = birmingham_boundary, display_output = FALSE)
}
