% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_discrete.R
\name{spm_discrete}
\alias{spm_discrete}
\title{Discrete multi-dimensional optimization}
\usage{
spm_discrete(dat, theta_range = seq(0.02, 0.2, by = 0.001), tol = NULL,
  verbose = FALSE)
}
\arguments{
\item{dat}{A data table.}

\item{theta_range}{A range of \code{theta} parameter (axe displacement of Gompertz function), default: from 0.001 to 0.09 with step of 0.001.}

\item{tol}{A tolerance threshold for matrix inversion (NULL by default).}

\item{verbose}{An indicator of verbosing output.}
}
\value{
A list of two elements ("dmodel", "cmodel"): (1) estimated parameters u, R, b, Sigma, Q, mu0, theta for discrete-time model and
(2) estimated parameters a, f1, Q, f, b, mu0, theta for continuous-time model. Note: b and mu0 from first list are different 
from b and mu0 from the second list.
}
\description{
Discrete multi-dimensional optimization
}
\details{
This function is way more faster that continuous \code{spm_continuous_MD(...)} (but less precise) and used mainly in 
estimation a starting point for the \code{spm_continuous_MD(...)}.
}
\examples{
library(stpm)
data <- simdata_discr(N=10)
#Parameters estimation
pars <- spm_discrete(data)
pars

}
\references{
Akushevich I., Kulminski A. and Manton K. (2005), Life tables with covariates: Dynamic model 
for Nonlinear Analysis of Longitudinal Data. Mathematical Population Studies, 12(2), pp.: 51-80.
<DOI:10.1080/08898480590932296>.
}
