% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Data pre-processing for analysis with stochastic process model methodology.}
\usage{
prepare_data(x, y, col.id = NULL, col.status = NULL, col.age = NULL,
  col.age.event = NULL, covariates = NULL, interval = 1,
  verbose = FALSE)
}
\arguments{
\item{x}{A path to the table with follow-up oservations (longitudinal study). Formats: csv, sas7bdat}

\item{y}{A path to the table with vital statistics (mortality). File formats: csv, sas7bdat}

\item{col.id}{A name of column containing subject ID. 
This ID should be the same in both longdat and vitstat tables.
If not provided, the first column in the x and y will be used by default.}

\item{col.status}{A name of the column containing status variable (0/1 which indicate alive/dead). 
If not provided - then the column #2 from the vital statistics dataset will be used.}

\item{col.age}{A name of age column (also called 't1'). 
If not provided then the 3rd column from the longitudinal dataset (x) will be used.}

\item{col.age.event}{A name of 'event' column.
The event column indicates a time when the even occured (e.g. system failure).
If not provided then the 3rd column from the vital statistics dataset will be used.}

\item{covariates}{A list of covariates. 
If covariates not provided, then all columns from longitudinal table having index > 3 will be used as covariates.}

\item{interval}{A number of breaks between observations for discrete model. Default = 1 unit of time.}

\item{verbose}{A verbosing output indicator. Default=FALSE.}
}
\value{
A list of two elements: first element contains a preprocessed data for continuous model, with arbitrary intervals between observations  and 
second element contains a prepocessed data table for a discrete model (with constant intervals between observations).
}
\description{
Data pre-processing for analysis with stochastic process model methodology.
}
\examples{
\dontrun{ 
library(stpm) 
data <- prepare_data(x=system.file("data","longdat.csv",package="stpm"), 
				   y=system.file("data","vitstat.csv",package="stpm"))
head(data[[1]])
head(data[[2]])
}
}

