% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneway.R
\name{od_oneway}
\alias{od_oneway}
\title{Aggregate od pairs they become non-directional}
\usage{
od_oneway(
  x,
  attrib = names(x[-c(1:2)])[vapply(x[-c(1:2)], is.numeric, TRUE)],
  id1 = names(x)[1],
  id2 = names(x)[2],
  stplanr.key = NULL
)
}
\arguments{
\item{x}{A data frame or SpatialLinesDataFrame, representing an OD matrix}

\item{attrib}{A vector of column numbers or names, representing variables to be aggregated.
By default, all numeric variables are selected.
aggregate}

\item{id1}{Optional (it is assumed to be the first column)
text string referring to the name of the variable containing
the unique id of the origin}

\item{id2}{Optional (it is assumed to be the second column)
text string referring to the name of the variable containing
the unique id of the destination}

\item{stplanr.key}{Optional key of unique OD pairs regardless of the order,
e.g., as generated by \code{\link[=od_id_max_min]{od_id_max_min()}} or \code{\link[=od_id_szudzik]{od_id_szudzik()}}}
}
\value{
\code{oneway} outputs a data frame (or \code{sf} data frame) with rows containing
results for the user-selected attribute values that have been aggregated.
}
\description{
For example, sum total travel in both directions.
}
\details{
Flow data often contains movement in two directions: from point A to point B
and then from B to A. This can be problematic for transport planning, because
the magnitude of flow along a route can be masked by flows the other direction.
If only the largest flow in either direction is captured in an analysis, for
example, the true extent of travel will by heavily under-estimated for
OD pairs which have similar amounts of travel in both directions.
Flows in both direction are often represented by overlapping lines with
identical geometries which can be confusing
for users and are difficult to plot.
}
\examples{
(od_min <- od_data_sample[c(1, 2, 9), 1:6])
(od_oneway <- od_oneway(od_min))
# (od_oneway_old = onewayid(od_min, attrib = 3:6)) # old implementation
nrow(od_oneway) < nrow(od_min) # result has fewer rows
sum(od_min$all) == sum(od_oneway$all) # but the same total flow
od_oneway(od_min, attrib = "all")
attrib <- which(vapply(flow, is.numeric, TRUE))
flow_oneway <- od_oneway(flow, attrib = attrib)
colSums(flow_oneway[attrib]) == colSums(flow[attrib]) # test if the colSums are equal
# Demonstrate the results from oneway and onewaygeo are identical
flow_oneway_sf <- od_oneway(flowlines_sf)
plot(flow_oneway_sf$geometry, lwd = flow_oneway_sf$All / mean(flow_oneway_sf$All))
}
\seealso{
Other od: 
\code{\link{od2line}()},
\code{\link{od2odf}()},
\code{\link{od_aggregate_from}()},
\code{\link{od_aggregate_to}()},
\code{\link{od_coords2line}()},
\code{\link{od_coords}()},
\code{\link{od_id}},
\code{\link{od_to_odmatrix}()},
\code{\link{odmatrix_to_od}()},
\code{\link{points2flow}()},
\code{\link{points2odf}()}
}
\concept{od}
