% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnet_group.R
\name{rnet_group}
\alias{rnet_group}
\alias{rnet_group.default}
\alias{rnet_group.sfc}
\alias{rnet_group.sf}
\alias{rnet_group.sfNetwork}
\title{Assign segments in a route network to groups}
\usage{
rnet_group(rnet, ...)

\method{rnet_group}{default}(rnet, ...)

\method{rnet_group}{sfc}(
  rnet,
  cluster_fun = igraph::clusters,
  d = NULL,
  as.undirected = TRUE,
  ...
)

\method{rnet_group}{sf}(
  rnet,
  cluster_fun = igraph::clusters,
  d = NULL,
  as.undirected = TRUE,
  ...
)

\method{rnet_group}{sfNetwork}(rnet, cluster_fun = igraph::clusters, ...)
}
\arguments{
\item{rnet}{An sf, sfc, or sfNetwork object representing a route network.}

\item{...}{Arguments passed to other methods.}

\item{cluster_fun}{The clustering function to use. Various clustering functions
are available in the \code{igraph} package. Default: \code{\link[igraph:components]{igraph::clusters()}}.}

\item{d}{Optional distance variable used to classify segments that are
close (within a certain distance specified by \code{d}) to each other but not
necessarily touching}

\item{as.undirected}{Coerce the graph created internally into an undirected
graph with \code{\link[igraph:as.directed]{igraph::as.undirected()}}? TRUE by default, which enables use
of a wider range of clutering functions.}
}
\value{
If the input rnet is an sf/sfc object, it returns an integer vector
reporting the groups of each network element. If the input is an sfNetwork
object, it returns an sfNetwork object with an extra column called
rnet_group representing the groups of each network element. In the latter
case, the connectivity of the spatial object is derived from the sfNetwork
object.
}
\description{
This function assigns linestring features, many of which in an
\code{sf} object can form route networks, into groups.
By default, the function \code{igraph::clusters()} is used to determine
group membership, but any \verb{igraph::cluster*()} function can be used.
See examples and the web page
\href{https://igraph.org/r/doc/communities.html}{igraph.org/r/doc/communities.html}
for more information. From that web page, the following clustering
functions are available:
}
\details{
\verb{cluster_edge_betweenness, cluster_fast_greedy, cluster_label_prop,}
\verb{cluster_leading_eigen, cluster_louvain, cluster_optimal, cluster_spinglass, cluster_walktrap}
}
\examples{
rnet <- rnet_breakup_vertices(stplanr::osm_net_example)
rnet$group <- rnet_group(rnet)
plot(rnet["group"])
# mapview::mapview(rnet["group"])
rnet$group_25m <- rnet_group(rnet, d = 25)
plot(rnet["group_25m"])
rnet$group_walktrap <- rnet_group(rnet, igraph::cluster_walktrap)
plot(rnet["group_walktrap"])
rnet$group_louvain <- rnet_group(rnet, igraph::cluster_louvain)
plot(rnet["group_louvain"])
rnet$group_fast_greedy <- rnet_group(rnet, igraph::cluster_fast_greedy)
plot(rnet["group_fast_greedy"])

# show sfNetwork implementation
sfn <- SpatialLinesNetwork(rnet)
sfn <- rnet_group(sfn)
plot(sfn@sl["rnet_group"])
}
\seealso{
Other rnet: 
\code{\link{SpatialLinesNetwork}},
\code{\link{calc_catchment_sum}()},
\code{\link{calc_catchment}()},
\code{\link{calc_moving_catchment}()},
\code{\link{calc_network_catchment}()},
\code{\link{find_network_nodes}()},
\code{\link{gsection}()},
\code{\link{islines}()},
\code{\link{lineLabels}()},
\code{\link{overline_spatial}()},
\code{\link{overline}()},
\code{\link{plot,SpatialLinesNetwork,ANY-method}},
\code{\link{plot,sfNetwork,ANY-method}},
\code{\link{rnet_breakup_vertices}()},
\code{\link{sln2points}()},
\code{\link{sum_network_links}()},
\code{\link{sum_network_routes}()}
}
\concept{rnet}
