% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialLinesNetwork.R
\name{sum_network_routes}
\alias{sum_network_routes}
\title{Summarise shortest path between nodes on network}
\usage{
sum_network_routes(sln, start, end, sumvars, combinations = FALSE)
}
\arguments{
\item{sln}{The SpatialLinesNetwork to use.}

\item{start}{Node ID(s) of route starts.}

\item{end}{Node ID(s) of route ends.}

\item{sumvars}{Character vector of variables for which to calculate
summary statistics.}

\item{combinations}{Boolean value indicating if all combinations of start
and ends should be calculated. If TRUE then every start Node ID will be routed
to every end Node ID. This is faster than passing every combination to start
and end. Default is FALSE.}
}
\description{
Summarise shortest path between nodes on network
}
\section{Details}{

Find the shortest path on the network between specified nodes and returns
a SpatialLinesdataFrame containing the path(s) and summary statistics of
each one.
}

\examples{
\donttest{
# tests fail on dev version of dplyr
sln <- SpatialLinesNetwork(route_network)
weightfield(sln) # field used to determine shortest path
shortpath <- sum_network_routes(sln, start = 1, end = 50, sumvars = "length")
plot(shortpath, col = "red", lwd = 4)
plot(sln, add = TRUE)
}
}
\seealso{
Other rnet: 
\code{\link{SpatialLinesNetwork}},
\code{\link{calc_catchment_sum}()},
\code{\link{calc_catchment}()},
\code{\link{calc_moving_catchment}()},
\code{\link{calc_network_catchment}()},
\code{\link{find_network_nodes}()},
\code{\link{gsection}()},
\code{\link{islines}()},
\code{\link{lineLabels}()},
\code{\link{overline2}()},
\code{\link{overline}()},
\code{\link{plot,SpatialLinesNetwork,ANY-method}},
\code{\link{plot,sfNetwork,ANY-method}},
\code{\link{sln2points}()},
\code{\link{sum_network_links}()}
}
\concept{rnet}
