% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialLinesNetwork.R
\name{SpatialLinesNetwork}
\alias{SpatialLinesNetwork}
\title{Create object of class SpatialLinesNetwork or sfNetwork}
\usage{
SpatialLinesNetwork(sl, uselonglat = FALSE, tolerance = 0)
}
\arguments{
\item{sl}{A SpatialLines or SpatialLinesDataFrame containing the lines to
use to create the network.}

\item{uselonglat}{A boolean value indicating if the data should be assumed
to be using WGS84 latitude/longitude coordinates. If \code{FALSE} or not
set, uses the coordinate system specified by the SpatialLines object.}

\item{tolerance}{A numeric value indicating the tolerance (in the units of
the coordinate system) to use as a tolerance with which to match nodes.}
}
\description{
Creates a new SpatialLinesNetwork (for SpatialLines) or sfNetwork (for sf)
object that can be used for routing analysis within R.
}
\section{Details}{

This function is used to create a new SpatialLinesNetwork from an existing
SpatialLines or SpatialLinesDataFrame object. A typical use case is to
represent a transport network for routing and other network analysis
functions. This function and the corresponding SpatialLinesNetwork
class is an implementation of the SpatialLinesNetwork developed by
Edzer Pebesma and presented on \href{http://rpubs.com/edzer/6767}{RPubs}.
The original implementation has been rewritten to better support large
(i.e., detailed city-size) networks and to provide additional methods
useful for conducting transport research following on from the initial
examples provided by \href{http://rpubs.com/janoskaz/10396}{Janoska(2013)}.
}

\examples{
SLN <- SpatialLinesNetwork(route_network)
class(SLN)
weightfield(SLN) # field used to determine shortest path
plot(SLN)
\dontrun{
points(sln2points(SLN)[1, ], cex = 5)
points(sln2points(SLN)[50, ], cex = 5)
shortpath <- sum_network_routes(SLN, 1, 50, sumvars = "length")
plot(shortpath, col = "red", lwd = 4, add = TRUE)
points(sln2points(SLN)[35, ], cex = 5)
shortpath <- sum_network_routes(SLN, 1, 35, sumvars = "length")
plot(shortpath, col = "red", lwd = 4, add = TRUE)
library(sf)
SLN_sf <- SpatialLinesNetwork(route_network_sf)
plot(SLN_sf)
shortpath <- sum_network_routes(SLN_sf, 1, 50, sumvars = "length")
plot(shortpath$geometry, col = "red", lwd = 4, add = TRUE)
}
}
\references{
Pebesma, E. (2013). Spatial Networks, URL:http://rpubs.com/edzer/6767.

Janoska, Z. (2013). Find shortest path in spatial network,
URL:http://rpubs.com/janoskaz/10396.
}
\seealso{
Other rnet: \code{\link{calc_catchment_sum}},
  \code{\link{calc_catchment}},
  \code{\link{calc_moving_catchment}},
  \code{\link{calc_network_catchment}},
  \code{\link{find_network_nodes}}, \code{\link{gsection}},
  \code{\link{islines}}, \code{\link{lineLabels}},
  \code{\link{overline2}}, \code{\link{overline}},
  \code{\link{plot,SpatialLinesNetwork,ANY-method}},
  \code{\link{plot,sfNetwork,ANY-method}},
  \code{\link{sln2points}},
  \code{\link{sum_network_links}},
  \code{\link{sum_network_routes}}
}
\concept{rnet}
