% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/routes.R
\name{route_cyclestreet}
\alias{route_cyclestreet}
\title{Plan a single route with CycleStreets.net}
\usage{
route_cyclestreet(from, to, plan = "fastest", silent = TRUE,
  pat = cyclestreet_pat())
}
\arguments{
\item{from}{Text string or coordinates (a numeric vector of
 \code{length = 2} representing latitude and longitude) representing a point
 on Earth.}

\item{to}{Text string or coordinates (a numeric vector of
 \code{length = 2} representing latitude and longitude) representing a point
 on Earth. This represents the destination of the trip.}

\item{plan}{Text strong of either "fastest", "quietest" or "balanced"}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}

\item{pat}{The API key used - this is usually aquired automatically through a helper
function}
}
\description{
Provides an R interface to the CycleStreets.net cycle planning API,
a route planner made by cyclists for cyclists.
The function returns a SpatialLinesDataFrame object representing the
an estimate of the fastest, quietest or most balance route.
Currently only works for the United Kingdom and part of continental Europe.
See \url{http://www.cyclestreets.net/api/}for more information.
}
\details{
This function uses the online routing service
CycleStreets.net to find routes suitable for cyclists
between origins and destinations. Requires an
internet connection, a CycleStreets.net API key
and origins and destinations within the UK to run.

Note that if \code{from} and \code{to} are supplied as
character strings (instead of lon/lat pairs), Google's
geo-coding services are used via \code{RgoogleMaps::getGeoCode()}.

You need to have an api key for this code to run.
Loading a locally saved copy of the api key text string
before running the function, for example, will ensure it
is available on any computer:

\code{
mytoken <- readLines("~/Dropbox/dotfiles/cyclestreets-api-key-rl")
Sys.setenv(CYCLESTREET = mytoken)
}

if you want the API key to be available in future
sessions, set it using the .Renviron file
e.g. on Linux machines in bash via:

\code{
echo "CYCLESTREET=f3fe3d078ac34737" >> ~/.Renviron
}

Read more about the .Renviron here: \code{?.Renviron}
}
\examples{
\dontrun{
# Plan the 'fastest' route between two points in Manchester
rf_mcr <- route_cyclestreet(from = "M3 4EE", to = "M1 4BT", plan = "fastest")
plot(rf_mcr)

# Plan the 'quietest' route from Hereford to Leeds
rqh <- route_cyclestreet(from = "Hereford", to = "Leeds", plan = "quietest")
plot(rq_hfd)

# Plan a 'balanced' route from Pedaller's Arms in Leeds
to the University of Leeds

rb_pa <- route_cyclestreet("Pedaller's Arms, Leeds", "University of Leeds", "balanced")

library(leaflet) # requires the leaflet CRAN package
# display the route on an interactive map
leaflet() \%>\% addTiles() \%>\%
  addPolylines(data = rb_pa)

woodys_route = route_cyclestreet(from = "Stokesley", plan = "fastest", to = "Leeds")

# Plan a route between two lat/lon pairs in the UK

p1 <- c(-2, 52)
p2 <- p1 + 1 # add a degree!
route_cyclestreet(p1, p2, "fastest")
}
}
\seealso{
line2route
}

