% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locstppm.R
\name{locstppm}
\alias{locstppm}
\title{Fit a local Poisson process model to a spatio-temporal point pattern}
\usage{
locstppm(
  X,
  formula,
  verbose = TRUE,
  mult = 4,
  hs = c("global", "local"),
  npx0 = 10,
  npt0 = 10
)
}
\arguments{
\item{X}{A \code{stp} object}

\item{formula}{An object of class \code{"formula"}: a symbolic description of
 the model to be fitted.
The current version only supports formulas depending on the spatial and temporal coordinates:
\code{x}, \code{y}, \code{t}.}

\item{verbose}{Default to \code{TRUE}}

\item{mult}{The multiplicand of the number of data points,
 for setting the number of dummy
points to generate for the quadrature scheme}

\item{hs}{Character string indicating whether to select fixed or variable bandwidths
for the kernel weights to be used in the log-likelihood.
In any of those cases, the well-supported rule-of-thumb for choosing the
bandwidth of a Gaussian kernel density estimator is employed.
If \code{hs = "global"} (default), a fixed bandwidth is selected.
If \code{hs = "local"}, an individual bandwidth is selected for each point in the
pattern  \code{X}.}

\item{npx0}{Number of lags for the space grid period for variable bandwidths kernel}

\item{npt0}{Number of lags for the time period for variable bandwidths kernel}
}
\value{
An object of class \code{locstppm}. A list of
\describe{
\item{\code{IntCoefs}}{The fitted global coefficients}
\item{\code{IntCoefs_local}}{The fitted local coefficients}
\item{\code{X}}{The \code{stp} object provided as input}
\item{\code{nX}}{The number of points in \code{X}}
\item{\code{I}}{Vector indicating which points are dummy or data}
\item{\code{y_resp}}{The response variable of the model fitted to the quadrature scheme}
\item{\code{formula}}{The formula provided as input}
\item{\code{l}}{Fitted intensity through the global parameters}
\item{\code{l_local}}{Fitted intensity through the local parameters}
\item{\code{mod_global}}{The \code{glm} object of the model fitted to the quadrature scheme}
\item{\code{newdata}}{The data used to fit the model, without the dummy points}
\item{\code{time}}{Time elapsed to fit the model, in minutes}
}
}
\description{
This function fits a Poisson process model to an observed spatio-temporal
point pattern stored in a \code{stp} object, that is, a Poisson model with
a set of parameters \eqn{\theta_i} for each point \eqn{i}.
}
\details{
We assume that the template model is a Poisson process, with a parametric
intensity or rate function \eqn{\lambda(\textbf{u}, t; \theta_i)}  with space
and time locations \eqn{\textbf{u} \in
W,  t \in T} and parameters \eqn{\theta_i \in \Theta.}

Estimation is performed through the fitting of a \code{glm} using a localized
version of the quadrature scheme by Berman and Turner (1992), firstly introduced
in the purely spatial context by Baddeley (2017), and in the spatio-temporal
framework by D'Angelo et al. (2023).
}
\examples{

\dontrun{
inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(0.005, 5), seed = 2)
inh_local <- locstppm(inh, formula = ~ x)

}


}
\references{
Baddeley, A. (2017). Local composite likelihood for spatial point processes. Spatial Statistics, 22, 261-295.

D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.
}
\seealso{
\link{stppm}
}
\author{
Nicoletta D'Angelo
}
