% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance.R
\name{sampleGlobalErrorVarianceOneIteration}
\alias{sampleGlobalErrorVarianceOneIteration}
\title{Sample one iteration of the (inverse gamma) global variance model}
\usage{
sampleGlobalErrorVarianceOneIteration(residual, dataset, rng, a, b)
}
\arguments{
\item{residual}{Outcome class}

\item{dataset}{ForestDataset class}

\item{rng}{C++ random number generator}

\item{a}{Global variance shape parameter}

\item{b}{Global variance scale parameter}
}
\value{
None
}
\description{
Sample one iteration of the (inverse gamma) global variance model
}
\examples{
X <- matrix(runif(10*100), ncol = 10)
y <- -5 + 10*(X[,1] > 0.5) + rnorm(100)
y_std <- (y-mean(y))/sd(y)
forest_dataset <- createForestDataset(X)
outcome <- createOutcome(y_std)
rng <- createCppRNG(1234)
a <- 1.0
b <- 1.0
sigma2 <- sampleGlobalErrorVarianceOneIteration(outcome, forest_dataset, rng, a, b)
}
