% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Outcome}
\alias{Outcome}
\title{Outcome / partial residual used to sample an additive model.}
\description{
The outcome class is wrapper around a vector of (mutable)
outcomes for ML tasks (supervised learning, causal inference).
When an additive tree ensemble is sampled, the outcome used to
sample a specific model term is the "partial residual" consisting
of the outcome minus the predictions of every other model term
(trees, group random effects, etc...).
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data_ptr}}{External pointer to a C++ Outcome class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Outcome-new}{\code{Outcome$new()}}
\item \href{#method-Outcome-get_data}{\code{Outcome$get_data()}}
\item \href{#method-Outcome-add_vector}{\code{Outcome$add_vector()}}
\item \href{#method-Outcome-subtract_vector}{\code{Outcome$subtract_vector()}}
\item \href{#method-Outcome-update_data}{\code{Outcome$update_data()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outcome-new"></a>}}
\if{latex}{\out{\hypertarget{method-Outcome-new}{}}}
\subsection{Method \code{new()}}{
Create a new Outcome object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outcome$new(outcome)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{outcome}}{Vector of outcome values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Outcome} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outcome-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-Outcome-get_data}{}}}
\subsection{Method \code{get_data()}}{
Extract raw data in R from the underlying C++ object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outcome$get_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
R vector containing (copy of) the values in \code{Outcome} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outcome-add_vector"></a>}}
\if{latex}{\out{\hypertarget{method-Outcome-add_vector}{}}}
\subsection{Method \code{add_vector()}}{
Update the current state of the outcome (i.e. partial residual) data by adding the values of \code{update_vector}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outcome$add_vector(update_vector)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{update_vector}}{Vector to be added to outcome}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outcome-subtract_vector"></a>}}
\if{latex}{\out{\hypertarget{method-Outcome-subtract_vector}{}}}
\subsection{Method \code{subtract_vector()}}{
Update the current state of the outcome (i.e. partial residual) data by subtracting the values of \code{update_vector}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outcome$subtract_vector(update_vector)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{update_vector}}{Vector to be subtracted from outcome}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Outcome-update_data"></a>}}
\if{latex}{\out{\hypertarget{method-Outcome-update_data}{}}}
\subsection{Method \code{update_data()}}{
Update the current state of the outcome (i.e. partial residual) data by replacing each element with the elements of \code{new_vector}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Outcome$update_data(new_vector)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_vector}}{Vector from which to overwrite the current data}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
}
