% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lto.R
\name{lto}
\alias{lto}
\alias{which_lto}
\alias{print_lto}
\alias{fetch_lto_version_tags}
\alias{lto_version_statuses}
\alias{configure_lto}
\alias{set_lto}
\title{Work with LTO versions}
\usage{
which_lto()

print_lto()

fetch_lto_version_tags(verbose = TRUE)

lto_version_statuses(verbose = TRUE)

configure_lto(
  version,
  verbose = TRUE,
  overwrite_json = FALSE,
  overwrite_rds = FALSE
)

set_lto(version, verbose = TRUE, load_background_collection = TRUE)
}
\arguments{
\item{verbose}{A logical value indicating whether status messages should be
output to console.}

\item{version}{A length-one character vector specifying an LTO version tag.
Set to "latest" to configure the latest numbered version, and "dev" to
configure the LTO developmental version.}

\item{overwrite_json}{A logical value indicating whether previously
downloaded JSON files (if any) should be re-downloaded and overwritten.}

\item{overwrite_rds}{A logical value indicating whether previously
generated Rds files (if any) should be regenerated and overwritten.}

\item{load_background_collection}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} A
logical value indicating whether the default background collection of all
LTO thematically annotated stories should be loaded into the stoRy
package environment when activating an LTO version. Setting this to FALSE
may result in some analysis functions not working.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Download, configure, view metadata about, and navigate among different
\acronym{LTO} versions.

\code{which_lto()} returns a length-one character vector corresponding to the
active LTO version. This is the version that is loaded into the stoRy
package environment. It is the \code{demo} version by default.

\code{print_lto()} prints basic \acronym{LTO} version metadata to console.

\code{fetch_lto_version_tags()} returns a character vector consisting of all
exiting LTO version tags. The \acronym{LTO} versioned release tags are
downloaded from the Theme Ontology GitHub website at
\url{https://github.com/theme-ontology/theming/releases}.

\code{lto_version_statuses()} prints to console the status (available for
download/cached/defunct) for each \acronym{LTO} version.

\code{configure_lto()} downloads and configures \acronym{LTO} version releases
hosted on the Theme Ontology website at
\url{https://www.themeontology.org/data}.

\code{set_lto()} sets an \acronym{LTO} version as the active version. This means
that package functions will act on this version. The active version is
set to \code{demo} by default.
}
\examples{
\dontrun{
# Check which LTO version is active:
which_lto()

# Print summary info about active LTO version to console:
print_lto()

# Print summary of existing LTO versions:
fetch_lto_version_tags()

# Store LTO version tags as a character vector:
lto_version_tags <- fetch_lto_version_tags()
lto_version_tags

# Configure the latest LTO version, only if it is not already setup:
configure_lto(version = "latest")

# Reconfigure the latest LTO version from scratch:
configure_lto(version = "latest", overwrite_json = TRUE, overwrite_rds = TRUE)

# Change to latest LTO version:
set_lto(version = "latest")
}
}
\references{
Paul Sheridan, Mikael Onsjö, and Janna Hastings, The Literary
Theme Ontology for Media Annotation and Information Retrieval,
Proceedings of JOWO2019: The Joint Ontology Workshops, Graz, Austria,
September 22-26 (\url{https://ceur-ws.org/Vol-2518/paper-WODHSA8.pdf}).
}
\seealso{
Run \link{lto-demo} to view the \acronym{LTO} demo data help page.

Run \code{\link[=print_stoRy_cache_info]{print_stoRy_cache_info()}} to list all cached files.
}
