% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_storysets.r
\docType{class}
\name{storysets}
\alias{storysets}
\title{Storysets objects}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
storysets
}
\arguments{
\item{storysets}{The object is created by passing an .smt format
storyset file name. See examples.}
}
\description{
The \pkg{stoRy} package uses the \code{storysets} object 
to store lists of story IDs.
}
\section{Fields}{


Each storysets object has the following five fields
\describe{
\item{file}{A string specifying the name of an .smt format
storysets file. See examples.}
\item{names}{A vector of storyset names.}
\item{comments}{A vector of comments describing the storysets.}
\item{no_of_storysets}{The number of storysets in the .smt file.}
\item{storysets_story_ids}{A list of vectors containing the storyset story IDs.}}
}

\examples{
#######################################################################
# List all storysets files available in the \\pkg{stoRy} package       #
#######################################################################
list.files(system.file("storysets", package = "stoRy"))

#######################################################################
# Load the Star Trek aliens storysets smt file and storysets object   #
#######################################################################
file <- system.file("storysets", "aliens.smt", package = "stoRy")
mystorysets <- storysets$new(file)
print(mystorysets)
}
\keyword{datasets}
