% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateEffect.R
\name{summary.estimateEffect}
\alias{summary.estimateEffect}
\alias{print.summary.estimateEffect}
\title{Summary for estimateEffect}
\usage{
\method{summary}{estimateEffect}(object, topics = NULL, nsim = 500, ...)
}
\arguments{
\item{object}{an object of class \code{"estimateEffect"}, usually a result of a call to
\code{\link{estimateEffect}}}

\item{topics}{a vector containing the topic numbers for each a summary is to be calculated.
Must be contained in the original \code{estimateEffect} object}

\item{nsim}{the number of simulations to use per parameter set to calculate the standard error.
Defaults to 500}

\item{...}{further arguments passed to or from other methods}
}
\description{
Create a summary regression table similar to those produced for \code{lm}
}
\details{
This function along with \code{\link{print.summary.estimateEffect}} creates
regression tables that look like typically summaries you see in R.  In general
we recommend that you use non-linearities such as splines via function like
\code{\link{s}} and in those circumstances the tables are not particularly
interpretable.

Confidence intervals are calculated by using draws from the covariance matrix
of each simulation to estimate the standard error.  Then a t-distribution approximation
is applied to calculate the various quantities of interest.
}
\seealso{
\code{\link{estimateEffect}} \code{\link{plot.estimateEffect}}
}
